/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.text.DateFormatSymbols;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableModel;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.bound.BoundAbsoluteTimeField;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.table.DefaultTableCellRenderer;
import org.openvpms.web.echo.table.DefaultTableHeaderRenderer;
import org.openvpms.web.echo.table.KeyTable;
import org.openvpms.web.resource.i18n.Messages;

public class OnlineBookingTimesLayoutStrategy
extends AbstractLayoutStrategy {
    static final String[] DAY_PREFIXES = new String[]{"mon", "tue", "wed", "thu", "fri", "sat", "sun"};

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        boolean edit = context.isEdit();
        ArchetypeNodes nodes = new ArchetypeNodes();
        for (String prefix : DAY_PREFIXES) {
            String openName = prefix + "Open";
            String startName = prefix + "StartTime";
            String endName = prefix + "EndTime";
            final Property open = properties.get(openName);
            final Property startTime = this.addTimeField(properties, startName, edit);
            final Property endTime = this.addTimeField(properties, endName, edit);
            this.addComponent(this.createComponent(open, parent, context));
            if (edit) {
                open.addModifiableListener(new ModifiableListener(){

                    public void modified(Modifiable modifiable) {
                        if (!open.getBoolean()) {
                            startTime.setValue(null);
                            endTime.setValue(null);
                            FocusHelper.setFocus((Component)OnlineBookingTimesLayoutStrategy.this.getComponent(open).getComponent());
                        }
                    }
                });
            }
            nodes.exclude(new String[]{openName, startName, endName});
        }
        this.setArchetypeNodes(nodes);
        return super.apply(object, properties, parent, context);
    }

    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        super.doSimpleLayout(object, parent, properties, container, context);
        for (String prefix : DAY_PREFIXES) {
            String openName = prefix + "Open";
            String startName = prefix + "StartTime";
            String endName = prefix + "EndTime";
            ComponentState open = this.getComponent(openName);
            ComponentState start = this.getComponent(startName);
            ComponentState end = this.getComponent(endName);
            this.setFocusTraversal(open);
            this.setFocusTraversal(start);
            this.setFocusTraversal(end);
        }
    }

    protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context) {
        ComponentGrid grid = super.createGrid(object, properties, context);
        Object[][] data = new Object[7][4];
        Object[] names = new Object[]{Messages.get((String)"workflow.scheduling.onlinebooking.day"), Messages.get((String)"workflow.scheduling.onlinebooking.open"), Messages.get((String)"workflow.scheduling.onlinebooking.start"), Messages.get((String)"workflow.scheduling.onlinebooking.end")};
        for (int i = 0; i < 7; ++i) {
            String prefix = DAY_PREFIXES[i];
            String openName = prefix + "Open";
            String startName = prefix + "StartTime";
            String endName = prefix + "EndTime";
            ComponentState open = this.getComponent(openName);
            ComponentState start = this.getComponent(startName);
            ComponentState end = this.getComponent(endName);
            data[i][0] = this.getWeekday(i);
            data[i][1] = open.getComponent();
            data[i][2] = start.getComponent();
            data[i][3] = end.getComponent();
        }
        DefaultTableModel model = new DefaultTableModel(data, names);
        KeyTable table = TableFactory.create((TableModel)model);
        table.setDefaultRenderer(Object.class, DefaultTableCellRenderer.INSTANCE);
        table.setDefaultHeaderRenderer(DefaultTableHeaderRenderer.DEFAULT);
        table.setRolloverEnabled(false);
        table.setSelectionEnabled(false);
        Label label = LabelFactory.create((String)"workflow.scheduling.onlinebooking.times");
        grid.add(new Component[]{label, table});
        return grid;
    }

    protected Property addTimeField(PropertySet properties, String name, boolean edit) {
        Property property = properties.get(name);
        BoundAbsoluteTimeField component = new BoundAbsoluteTimeField(property, false);
        if (!edit) {
            component.setEnabled(false);
        }
        this.addComponent(new ComponentState((Component)component, property));
        return property;
    }

    private String getWeekday(int index) {
        String result;
        String[] weekdays = DateFormatSymbols.getInstance().getWeekdays();
        switch (index) {
            case 0: {
                result = weekdays[2];
                break;
            }
            case 1: {
                result = weekdays[3];
                break;
            }
            case 2: {
                result = weekdays[4];
                break;
            }
            case 3: {
                result = weekdays[5];
                break;
            }
            case 4: {
                result = weekdays[6];
                break;
            }
            case 5: {
                result = weekdays[7];
                break;
            }
            default: {
                result = weekdays[1];
            }
        }
        return result;
    }
}

