/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.workflow.appointment.AbstractAppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.Slot;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;

class MultiScheduleGrid
extends AbstractAppointmentGrid {
    private final List<Slot> slots = new ArrayList<Slot>();

    MultiScheduleGrid(Entity scheduleView, Date date, Map<Entity, ScheduleEvents> events, AppointmentRules rules, RosterService rosterService) {
        super(scheduleView, date, -1, -1, rules, rosterService);
        this.setEvents(events);
        ZonedDateTime slotStart = this.getSlotTimeForMinutes(this.getStartMins());
        ZonedDateTime end = this.getSlotTimeForMinutes(this.getEndMins());
        int slotSize = this.getSlotSize();
        while (slotStart.compareTo(end) < 0) {
            ZonedDateTime slotEnd = slotStart.plusMinutes(slotSize);
            if (slotEnd.compareTo(end) > 0) {
                slotEnd = end;
            }
            this.slots.add(new Slot(slotStart, slotEnd));
            slotStart = slotEnd;
        }
    }

    @Override
    public PropertySet getEvent(Schedule schedule, int slot) {
        int slotSize;
        Date start;
        PropertySet result = null;
        if (slot >= 0 && slot < this.getSlots() && (result = schedule.getEvent(start = this.getStartTime(schedule, slot), slotSize = this.getSlotSize())) == null) {
            Date end = this.getEndTime(schedule, slot);
            result = schedule.getIntersectingEvent(start, end, slotSize);
        }
        return result;
    }

    public int getFirstSlot(int minutes) {
        if (minutes < this.getStartMins() || minutes > this.getEndMins()) {
            return -1;
        }
        return (minutes - this.getStartMins()) / this.getSlotSize();
    }

    @Override
    public List<Slot> getSlotTimes() {
        return this.slots;
    }

    @Override
    protected void addEvent(Entity schedule, PropertySet event) {
        int slotEnd;
        super.addEvent(schedule, event);
        Date startTime = event.getDate("act.startTime");
        Date endTime = event.getDate("act.endTime");
        Date startDate = DateRules.getDate((Date)startTime);
        Date endDate = DateRules.getDate((Date)endTime);
        int slotStart = startDate.compareTo(this.getStartDate()) < 0 ? this.getStartMins() : this.getSlotMinutes(startTime, false);
        int n = slotEnd = endDate.compareTo(this.getStartDate()) > 0 ? this.getEndMins() : this.getSlotMinutes(endTime, true);
        if (this.getStartMins() > slotStart) {
            this.setStartMins(slotStart);
        }
        if (this.getEndMins() < slotEnd) {
            this.setEndMins(slotEnd);
        }
    }

    private void setEvents(Map<Entity, ScheduleEvents> events) {
        int startMins = -1;
        int endMins = -1;
        int slotSize = -1;
        this.setSlotSize(-1);
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        for (Entity entity : events.keySet()) {
            int end;
            Schedule column = this.createSchedule(entity);
            schedules.add(column);
            int start = column.getStartMins();
            if (startMins == -1 || start < startMins) {
                startMins = start;
            }
            if ((end = column.getEndMins()) > endMins) {
                endMins = end;
            }
            if (slotSize != -1 && column.getSlotSize() >= slotSize) continue;
            slotSize = column.getSlotSize();
        }
        if (startMins == -1) {
            startMins = 480;
        }
        if (endMins == -1) {
            endMins = 1080;
        }
        if (slotSize == -1) {
            slotSize = 15;
        }
        this.setSchedules(schedules);
        this.setStartMins(startMins);
        this.setEndMins(endMins);
        this.setSlotSize(slotSize);
        for (Map.Entry entry : events.entrySet()) {
            Entity schedule = (Entity)entry.getKey();
            List sets = ((ScheduleEvents)entry.getValue()).getEvents();
            for (PropertySet set : sets) {
                this.addEvent(schedule, set);
            }
        }
    }
}

