/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import java.util.Objects;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AppointmentBrowser;
import org.openvpms.web.workspace.workflow.appointment.AppointmentCRUDWindow;
import org.openvpms.web.workspace.workflow.appointment.AppointmentSchedules;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleBrowser;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleCRUDWindow;
import org.openvpms.web.workspace.workflow.scheduling.SchedulingWorkspace;

public class AppointmentWorkspace
extends SchedulingWorkspace {
    public AppointmentWorkspace(Context context, Preferences preferences) {
        super("workflow.scheduling", (Archetypes<Entity>)Archetypes.create((String)"entity.organisationScheduleView", Entity.class), context, preferences, "entity.preferenceGroupScheduling");
    }

    @Override
    public void setObject(Entity object) {
        ScheduleBrowser browser = this.getBrowser();
        PropertySet marked = null;
        boolean isCut = false;
        if (browser != null) {
            marked = browser.getMarked();
            isCut = browser.isCut();
        }
        this.getContext().setScheduleView(object);
        super.setObject(object);
        browser = this.getBrowser();
        if (browser != null && marked != null) {
            browser.setMarked(marked, isCut);
        }
    }

    public boolean canUpdate(String shortName) {
        return super.canUpdate(shortName) || "act.customerAppointment".equals(shortName);
    }

    public void update(IMObject object) {
        if (TypeHelper.isA((IMObject)object, (String)"entity.organisationScheduleView")) {
            if (!Objects.equals(this.getObject(), object)) {
                this.setObject((Entity)object);
            }
        } else if (TypeHelper.isA((IMObject)object, (String)"act.customerAppointment")) {
            Act act = (Act)object;
            if (!Objects.equals(this.getCRUDWindow().getObject(), act)) {
                AppointmentRules rules;
                Entity view;
                IMObjectBean bean = IMObjectHelper.getBean((IMObject)act);
                Entity schedule = (Entity)bean.getTarget("schedule", Entity.class);
                Party location = this.getContext().getLocation();
                if (schedule != null && location != null && (view = (rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class)).getScheduleView(location, schedule)) != null) {
                    this.setScheduleView(view, act.getActivityStartTime());
                    ScheduleBrowser scheduleBrowser = this.getBrowser();
                    scheduleBrowser.setSelected(scheduleBrowser.getEvent(act));
                    this.getCRUDWindow().setObject((IMObject)act);
                }
            }
        }
    }

    @Override
    public void show() {
        super.show();
        AppointmentBrowser browser = (AppointmentBrowser)this.getBrowser();
        if (browser != null) {
            browser.scrollToRow(true);
        }
    }

    @Override
    protected void setScheduleView(Entity view, Date date) {
        this.getContext().setScheduleView(view);
        super.setScheduleView(view, date);
    }

    @Override
    protected ScheduleBrowser createBrowser() {
        Context context = this.getContext();
        return new AppointmentBrowser(context.getLocation(), (LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
    }

    @Override
    protected ScheduleCRUDWindow createCRUDWindow() {
        return new AppointmentCRUDWindow((AppointmentBrowser)this.getBrowser(), this.getContext(), this.getHelpContext());
    }

    @Override
    protected void onQuery() {
        Context context = this.getContext();
        ScheduleBrowser browser = this.getBrowser();
        context.setScheduleDate(browser.getDate());
        context.setSchedule(browser.getSelectedSchedule());
        Act act = browser.getAct(browser.getSelected());
        this.getCRUDWindow().setObject((IMObject)act);
    }

    @Override
    protected void eventSelected(PropertySet event) {
        this.updateContext();
        super.eventSelected(event);
        this.getContext().setAppointment((Act)this.getCRUDWindow().getObject());
    }

    @Override
    protected void onEdit(PropertySet event) {
        this.updateContext();
        super.onEdit(event);
    }

    protected Entity getLatest() {
        return (Entity)this.getLatest((IMObject)this.getContext().getScheduleView());
    }

    @Override
    protected Entity getDefaultView(Party location, Preferences prefs) {
        AppointmentSchedules schedules = new AppointmentSchedules(location, prefs);
        return schedules.getDefaultScheduleView();
    }

    private void updateContext() {
        Party schedule = (Party)this.getBrowser().getSelectedSchedule();
        this.getContext().setSchedule((Entity)schedule);
    }
}

