/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import echopointng.layout.TableLayoutDataEx;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.layout.RowLayoutData;
import nextapp.echo2.app.table.TableCellRenderer;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AppointmentTableModel;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;

class AppointmentTableHeaderRenderer
implements TableCellRenderer {
    public static AppointmentTableHeaderRenderer INSTANCE = new AppointmentTableHeaderRenderer();

    private AppointmentTableHeaderRenderer() {
    }

    public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
        Label component;
        AppointmentTableModel model = (AppointmentTableModel)table.getModel();
        boolean singleScheduleView = model.isSingleScheduleView();
        Schedule schedule = model.getSchedule(column, row);
        if (!singleScheduleView && schedule != null && !schedule.getAreas().isEmpty()) {
            component = this.getRosterHeading(schedule, model);
        } else {
            component = this.createHeading(model.getColumnName(column));
            component.setLayoutData((LayoutData)this.getLayoutData());
        }
        if (!singleScheduleView && schedule != null) {
            Entity entity = schedule.getSchedule();
            ++column;
            int span = 1;
            while (column < model.getColumnCount() && Objects.equals(entity, model.getScheduleEntity(column, row))) {
                ++column;
                ++span;
            }
            if (span > 1) {
                TableLayoutDataEx layout = (TableLayoutDataEx)component.getLayoutData();
                if (layout == null) {
                    layout = this.getLayoutData();
                    component.setLayoutData((LayoutData)layout);
                }
                layout.setColSpan(span);
            }
        }
        return component;
    }

    private Component getRosterHeading(Schedule schedule, AppointmentTableModel model) {
        Row result;
        if (model.showRoster()) {
            RosterService service = (RosterService)ServiceHelper.getBean(RosterService.class);
            ArrayList roster = new ArrayList();
            for (Entity entity : schedule.getAreas()) {
                List events = service.getEvents(entity, model.getGrid().getStartDate());
                roster.addAll(events);
            }
            Grid grid = GridFactory.create((int)2);
            if (!roster.isEmpty()) {
                for (PropertySet event : roster) {
                    String name = event.getString("user.name");
                    Date from = event.getDate("act.startTime");
                    Date to = event.getDate("act.endTime");
                    grid.add((Component)LabelFactory.text((String)name));
                    grid.add((Component)LabelFactory.text((String)(DateFormatter.formatTime((Date)from, (boolean)false) + " - " + DateFormatter.formatTime((Date)to, (boolean)false))));
                }
            } else {
                grid.add((Component)LabelFactory.create((String)"workflow.scheduling.appointment.noroster"));
            }
            Row row = this.getRosterHeading(schedule, model, false);
            result = ColumnFactory.create((Component[])new Component[]{row, grid});
        } else {
            result = this.getRosterHeading(schedule, model, true);
        }
        result.setLayoutData((LayoutData)this.getLayoutData());
        return result;
    }

    private Row getRosterHeading(Schedule schedule, AppointmentTableModel model, boolean show) {
        String style = show ? "Roster.show" : "Roster.hide";
        Button button = ButtonFactory.create(null, (String)style, () -> model.setShowRoster(show));
        Label heading = this.createHeading(schedule);
        RowLayoutData layout = RowFactory.layout((Alignment)Alignment.ALIGN_TOP);
        heading.setLayoutData((LayoutData)layout);
        button.setLayoutData((LayoutData)layout);
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{heading, button});
    }

    private Label createHeading(Schedule schedule) {
        return this.createHeading(schedule.getName());
    }

    private Label createHeading(String name) {
        return LabelFactory.text((String)name, (String)"bold");
    }

    private TableLayoutDataEx getLayoutData() {
        TableLayoutDataEx result = TableHelper.getTableLayoutDataEx((String)"Table.Header.Layout");
        if (result == null) {
            result = new TableLayoutDataEx();
        }
        result.setAlignment(Alignment.ALIGN_TOP);
        return result;
    }
}

