/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import echopointng.TabbedPane;
import echopointng.tabbedpane.TabModel;
import echopointng.table.TableActionEventEx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.ColumnLayoutData;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.Slot;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractBrowserListener;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.TabbedBrowserListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.factory.TabbedPaneFactory;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.TableEx;
import org.openvpms.web.echo.tabpane.TabPaneModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractAppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGridView;
import org.openvpms.web.workspace.workflow.appointment.AppointmentHelper;
import org.openvpms.web.workspace.workflow.appointment.AppointmentQuery;
import org.openvpms.web.workspace.workflow.appointment.AppointmentTableModel;
import org.openvpms.web.workspace.workflow.appointment.FreeAppointmentSlotBrowser;
import org.openvpms.web.workspace.workflow.appointment.FreeAppointmentSlotQuery;
import org.openvpms.web.workspace.workflow.appointment.MultiDayScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.MultiDayTableModel;
import org.openvpms.web.workspace.workflow.appointment.MultiScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.MultiScheduleTableModel;
import org.openvpms.web.workspace.workflow.appointment.SingleScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.SingleScheduleTableModel;
import org.openvpms.web.workspace.workflow.appointment.TimeRange;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageSummaryTableModel;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageTableModel;
import org.openvpms.web.workspace.workflow.appointment.boarding.CheckInOutTableModel;
import org.openvpms.web.workspace.workflow.appointment.boarding.CheckInScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.boarding.CheckInTableModel;
import org.openvpms.web.workspace.workflow.appointment.boarding.CheckOutScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.boarding.CheckOutTableModel;
import org.openvpms.web.workspace.workflow.appointment.boarding.DefaultCageTableModel;
import org.openvpms.web.workspace.workflow.scheduling.IntersectComparator;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleBrowser;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

public class AppointmentBrowser
extends ScheduleBrowser {
    private final LayoutContext context;
    private final ScheduleColours colours;
    private final AppointmentRules rules;
    private final RosterService rosterService;
    private Label title;
    private TimeRange lastTimeRange;
    private TabPaneModel model;
    private TabbedPane tab;
    private FreeAppointmentSlotQuery freeSlotQuery;
    private FreeAppointmentSlotBrowser freeSlotBrowser;
    private TabbedBrowserListener listener;
    private int appointmentsTab;
    private int freeSlotsTab;
    private int lastTab;

    public AppointmentBrowser(Party location, LayoutContext context) {
        this(new AppointmentQuery(location, context.getPreferences()), context);
    }

    public AppointmentBrowser(AppointmentQuery query, LayoutContext context) {
        super(query, context.getContext());
        this.context = context;
        this.rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
        this.rosterService = (RosterService)ServiceHelper.getBean(RosterService.class);
        this.colours = (ScheduleColours)((Object)ServiceHelper.getBean(ScheduleColours.class));
    }

    public void setListener(TabbedBrowserListener listener) {
        this.listener = listener;
    }

    @Override
    public void query() {
        TimeRange timeRange = this.getQuery().getTimeRange();
        boolean reselect = timeRange.equals((Object)this.lastTimeRange);
        this.lastTimeRange = timeRange;
        this.doQuery(reselect);
        this.updateTitle();
    }

    public boolean isAppointmentsSelected() {
        return this.tab.getSelectedIndex() == this.appointmentsTab;
    }

    public void setSelected(Entity schedule, Date startTime) {
        Cell cell = this.getModel().getCell(schedule.getObjectReference(), startTime);
        if (cell != null) {
            this.setSelectedCell(cell);
        }
    }

    public void scrollToRow(boolean selected) {
        TableEx table = this.getTable();
        if (table != null) {
            Cell cell;
            ScheduleTableModel model = this.getModel();
            int slot = -1;
            if (selected && (cell = model.getSelected()) != null) {
                slot = cell.getRow();
            }
            if ((!selected || slot == -1) && this.isAutoScroll() && model instanceof AppointmentTableModel) {
                Date now;
                AppointmentGrid grid;
                AppointmentTableModel appointmentTableModel = (AppointmentTableModel)model;
                if (DateRules.isToday((Date)this.getDate()) && (slot = (grid = appointmentTableModel.getGrid()).getSlot(now = new Date())) == -1 && grid.getStartTime(grid.getSlots() - 1).compareTo(now) <= 0) {
                    slot = grid.getSlots() - 1;
                }
            }
            if (slot >= 2) {
                slot -= 2;
            }
            table.setScrollToRow(slot);
        }
    }

    @Override
    protected void onQuery() {
        super.onQuery();
        this.scrollToRow(true);
    }

    @Override
    protected void onNow() {
        this.scrollToRow(false);
    }

    @Override
    protected void restore(ScheduleTableModel.State state) {
        super.restore(state);
        this.scrollToRow(true);
    }

    @Override
    protected AppointmentQuery getQuery() {
        return (AppointmentQuery)super.getQuery();
    }

    @Override
    protected ScheduleEventGrid createEventGrid(Date date, Map<Entity, ScheduleEvents> events) {
        ScheduleEventGrid grid;
        Set<Entity> schedules = events.keySet();
        Entity scheduleView = this.getScheduleView();
        AppointmentQuery query = this.getQuery();
        AppointmentQuery.DateRange dateRange = query.getDateRange();
        if (dateRange != AppointmentQuery.DateRange.DAY && AppointmentHelper.isMultiDayView(scheduleView)) {
            int days = query.getDays();
            AppointmentQuery.Show show = query.getShow();
            grid = show == AppointmentQuery.Show.CAGE || show == AppointmentQuery.Show.SUMMARY ? new CageScheduleGrid(scheduleView, date, days, events, this.rules) : (show == AppointmentQuery.Show.CHECKIN ? new CheckInScheduleGrid(scheduleView, date, days, events, this.rules) : (show == AppointmentQuery.Show.CHECKOUT ? new CheckOutScheduleGrid(scheduleView, date, days, events, this.rules) : new MultiDayScheduleGrid(scheduleView, date, days, events, this.rules)));
        } else {
            Entity schedule;
            ScheduleEvents sets;
            AbstractAppointmentGrid appointmentGrid = schedules.size() == 1 ? (!this.hasOverlappingEvents(sets = events.get(schedule = schedules.iterator().next()), schedule) ? new SingleScheduleGrid(scheduleView, date, schedule, sets, this.rules, this.rosterService) : new MultiScheduleGrid(scheduleView, date, events, this.rules, this.rosterService)) : new MultiScheduleGrid(this.getScheduleView(), date, events, this.rules, this.rosterService);
            boolean showRoster = false;
            ScheduleTableModel model = this.getModel();
            showRoster = model != null && model.getGrid() instanceof AbstractAppointmentGrid ? ((AbstractAppointmentGrid)model.getGrid()).showRoster() : this.context.getPreferences().getBoolean("entity.preferenceGroupScheduling", "expandRoster", false);
            appointmentGrid.setShowRoster(showRoster);
            TimeRange range = query.getTimeRange();
            grid = this.createGridView(appointmentGrid, range);
        }
        return grid;
    }

    @Override
    protected ScheduleTableModel createTableModel(ScheduleEventGrid grid) {
        ScheduleTableModel model;
        if (grid instanceof CageScheduleGrid) {
            CageScheduleGrid cageGrid = (CageScheduleGrid)grid;
            model = this.getQuery().getShow() == AppointmentQuery.Show.CAGE ? new DefaultCageTableModel(cageGrid, this.getContext(), this.colours) : new CageSummaryTableModel(cageGrid, this.getContext(), this.colours);
        } else {
            model = grid instanceof MultiDayScheduleGrid ? new MultiDayTableModel((MultiDayScheduleGrid)grid, this.getContext(), this.colours) : (grid instanceof CheckInScheduleGrid ? new CheckInTableModel((CheckInScheduleGrid)grid, this.getContext(), this.colours) : (grid instanceof CheckOutScheduleGrid ? new CheckOutTableModel((CheckOutScheduleGrid)grid, this.getContext(), this.colours) : (grid.getSchedules().size() == 1 ? new SingleScheduleTableModel((AppointmentGrid)grid, this.getContext(), this.colours) : new MultiScheduleTableModel((AppointmentGrid)grid, this.getContext(), this.colours))));
        }
        return model;
    }

    @Override
    protected Component doLayout() {
        Column tabContainer = new Column();
        this.model = new TabPaneModel((Component)tabContainer);
        this.tab = TabbedPaneFactory.create((TabModel)this.model);
        this.title = LabelFactory.create(null, (String)"bold");
        ColumnLayoutData layout = new ColumnLayoutData();
        layout.setAlignment(Alignment.ALIGN_CENTER);
        this.title.setLayoutData((LayoutData)layout);
        Column column = ColumnFactory.create((String)"Inset", (Component[])new Component[]{ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{this.title, this.layoutQuery()})});
        this.appointmentsTab = this.addTab(Messages.get((String)"workflow.scheduling.appointment.title"), (Component)column);
        this.freeSlotsTab = this.addTab(Messages.get((String)"workflow.scheduling.appointment.find.title"), (Component)ColumnFactory.create((String)"Inset"));
        this.tab.setSelectedIndex(this.appointmentsTab);
        this.lastTab = this.appointmentsTab;
        TableEx table = this.getTable();
        tabContainer.add((Component)this.tab);
        SplitPane component = SplitPaneFactory.create((int)5, (String)"AppointmentBrowser", (Component[])new Component[]{tabContainer});
        if (this.getScheduleView() != null && table != null) {
            this.addTable((Table)table, (Component)component);
        }
        this.tab.addPropertyChangeListener(evt -> this.onBrowserChanged());
        return component;
    }

    @Override
    protected void onSelected(TableActionEventEx event) {
        ScheduleTableModel model = this.getModel();
        if (model instanceof CageTableModel) {
            CageTableModel cageModel = (CageTableModel)model;
            if (cageModel.isCageType(event.getRow())) {
                cageModel.toggle(event.getRow());
                this.getTable().getSelectionModel().clearSelection();
            } else {
                super.onSelected(event);
            }
        } else if (model instanceof CheckInOutTableModel) {
            CheckInOutTableModel checkInOutTableModel = (CheckInOutTableModel)model;
            if (!checkInOutTableModel.isEmpty()) {
                super.onSelected(event);
            } else {
                this.getTable().getSelectionModel().clearSelection();
            }
        } else {
            super.onSelected(event);
        }
    }

    private boolean isAutoScroll() {
        return this.context.getPreferences().getBoolean("entity.preferenceGroupScheduling", "autoScroll", false);
    }

    private void updateTitle() {
        String date;
        String schedName;
        Entity view = this.getScheduleView();
        AppointmentQuery.DateRange dateRange = this.getQuery().getDateRange();
        Entity schedule = this.getQuery().getSchedule();
        String viewName = view != null ? view.getName() : null;
        String string = schedName = schedule != null ? schedule.getName() : null;
        if (view != null && schedule != null) {
            ScheduleEventGrid grid = this.getModel().getGrid();
            if (dateRange == AppointmentQuery.DateRange.DAY) {
                date = Messages.format((String)"workflow.scheduling.appointment.day", (Object[])new Object[]{grid.getStartDate()});
            } else {
                Date from = grid.getStartDate();
                Date to = grid.getEndDate();
                boolean sameMonth = DateRules.getMonthStart((Date)from).equals(DateRules.getMonthStart((Date)to));
                date = dateRange == AppointmentQuery.DateRange.WEEK ? (sameMonth ? Messages.format((String)"workflow.scheduling.appointment.week.samemonth", (Object[])new Object[]{from, to}) : Messages.format((String)"workflow.scheduling.appointment.week.diffmonth", (Object[])new Object[]{from, to})) : (sameMonth ? Messages.format((String)"workflow.scheduling.appointment.month.samemonth", (Object[])new Object[]{from, to}) : Messages.format((String)"workflow.scheduling.appointment.month.diffmonth", (Object[])new Object[]{from, to}));
            }
        } else {
            date = Messages.format((String)"workflow.scheduling.appointment.day", (Object[])new Object[]{this.getDate()});
        }
        String text = viewName != null && schedName != null ? Messages.format((String)"workflow.scheduling.appointment.viewscheduledate", (Object[])new Object[]{viewName, schedName, date}) : (viewName != null ? Messages.format((String)"workflow.scheduling.appointment.viewdate", (Object[])new Object[]{viewName, date}) : Messages.format((String)"workflow.scheduling.appointment.date", (Object[])new Object[]{date}));
        this.title.setText(text);
    }

    private AppointmentGrid createGridView(AppointmentGrid grid, TimeRange timeRange) {
        int startMins = timeRange.getStartMins();
        int endMins = timeRange.getEndMins();
        if (startMins < grid.getStartMins()) {
            startMins = grid.getStartMins();
        }
        if (endMins > grid.getEndMins()) {
            endMins = grid.getEndMins();
        }
        if (startMins > endMins) {
            startMins = endMins;
        }
        return new AppointmentGridView(grid, startMins, endMins, this.rules, this.rosterService);
    }

    private boolean hasOverlappingEvents(ScheduleEvents events, Entity schedule) {
        int slotSize = AbstractAppointmentGrid.getSlotSize(schedule, this.rules);
        IntersectComparator comparator = new IntersectComparator(slotSize, this.rules);
        ArrayList<PropertySet> list = new ArrayList<PropertySet>();
        for (PropertySet event : events.getEvents()) {
            if (Collections.binarySearch(list, event, comparator) >= 0) {
                return true;
            }
            list.add(event);
        }
        return false;
    }

    private void removeBrowser() {
        Component parent = this.getComponent();
        if (parent.getComponentCount() == 2) {
            parent.remove(parent.getComponents()[1]);
        }
    }

    private void onBrowserChanged() {
        int index = this.tab.getSelectedIndex();
        if (index != this.lastTab) {
            this.lastTab = index;
            if (index == this.appointmentsTab) {
                this.onAppointmentsSelected();
            } else {
                this.onFreeSlotsSelected();
            }
            if (this.listener != null) {
                this.listener.onBrowserChanged();
            }
        }
    }

    private void onAppointmentsSelected() {
        Component parent = this.getComponent();
        this.removeBrowser();
        TableEx table = this.getTable();
        if (this.getScheduleView() != null && table != null) {
            this.addTable((Table)table, parent);
        }
    }

    private void onFreeSlotsSelected() {
        if (this.freeSlotQuery == null) {
            Party location = this.getContext().getLocation();
            this.freeSlotQuery = new FreeAppointmentSlotQuery(location, this.getScheduleView(), this.getSelectedSchedule(), this.getQuery().getDate(), this.context.getPreferences(), this.context);
            this.freeSlotBrowser = new FreeAppointmentSlotBrowser(this.freeSlotQuery, this.context);
            this.freeSlotBrowser.addBrowserListener((BrowserListener)new AbstractBrowserListener<Slot>(){

                public void selected(Slot slot) {
                    AppointmentBrowser.this.onFreeSlotSelected(slot);
                }
            });
            Component query = this.layoutQuery(this.freeSlotQuery, new ActionListener(){

                public void onAction(ActionEvent event) {
                    AppointmentBrowser.this.freeSlotBrowser.query();
                }
            });
            this.model.getTabContentAt(this.freeSlotsTab).add(query);
        }
        Component parent = this.getComponent();
        this.removeBrowser();
        parent.add(this.freeSlotBrowser.getComponent());
    }

    private void onFreeSlotSelected(Slot slot) {
        Entity scheduleView = this.freeSlotBrowser.getScheduleView();
        Entity schedule = this.freeSlotBrowser.getSchedule(slot);
        if (scheduleView != null && schedule != null) {
            this.setScheduleView(scheduleView);
            Date startTime = slot.getStartTime();
            this.setDate(startTime);
            this.getQuery().setTimeRange(TimeRange.getRange(startTime));
            this.query();
            this.setSelected(schedule, startTime);
            this.tab.setSelectedIndex(this.appointmentsTab);
        }
    }

    private int addTab(String displayName, Component component) {
        int result = this.model.size();
        int shortcut = result + 1;
        String text = "&" + shortcut + " " + displayName;
        component = ColumnFactory.create((String)"Inset", (Component[])new Component[]{component});
        this.model.addTab(text, component);
        return result;
    }
}

