/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;

public abstract class AbstractScheduleEventGrid
implements ScheduleEventGrid {
    private final Entity scheduleView;
    private final AppointmentRules rules;
    private final ZoneId zone = ZoneId.systemDefault();
    private List<Schedule> schedules = Collections.emptyList();
    private Date startDate;
    private ZonedDateTime startZonedDateTime;
    private Date endDate;

    public AbstractScheduleEventGrid(Entity scheduleView, Date date, AppointmentRules rules) {
        this(scheduleView, date, date, rules);
    }

    public AbstractScheduleEventGrid(Entity scheduleView, Date startDate, Date endDate, AppointmentRules rules) {
        this.scheduleView = scheduleView;
        this.rules = rules;
        this.setStartDate(startDate);
        this.setEndDate(endDate);
    }

    @Override
    public Entity getScheduleView() {
        return this.scheduleView;
    }

    @Override
    public List<Schedule> getSchedules() {
        return this.schedules;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    public abstract int getSlotSize();

    protected ZonedDateTime getStartZonedDateTime() {
        return this.startZonedDateTime;
    }

    protected void setSchedules(List<Schedule> schedules) {
        this.schedules = schedules;
    }

    protected void addEvent(Entity schedule, PropertySet event) {
        int index = -1;
        boolean found = false;
        Schedule column = null;
        Schedule match = null;
        boolean blockingEvent = Schedule.isBlockingEvent(event);
        List<Schedule> columns = this.getSchedules();
        for (int i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            if (!column.getSchedule().equals(schedule)) continue;
            if (blockingEvent) {
                found = true;
                break;
            }
            if (column.hasIntersectingEvent(event, this.getSlotSize())) {
                match = column;
                index = i;
                continue;
            }
            found = true;
            break;
        }
        if (!found) {
            column = new Schedule(match, this.rules);
            columns.add(index + 1, column);
        }
        column.addEvent(event);
    }

    ZonedDateTime toZonedDateTime(Date time) {
        return ZonedDateTime.ofInstant(time.toInstant(), this.zone);
    }

    AppointmentRules getAppointmentRules() {
        return this.rules;
    }

    private void setStartDate(Date startDate) {
        this.startDate = DateRules.getDate((Date)startDate);
        this.startZonedDateTime = this.toZonedDateTime(startDate);
    }

    private void setEndDate(Date endDate) {
        this.endDate = DateRules.getDate((Date)endDate);
    }
}

