/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import org.openvpms.archetype.i18n.time.DateDurationFormatter;
import org.openvpms.archetype.i18n.time.DurationFormatter;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeriesEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeriesViewer;
import org.openvpms.web.workspace.workflow.scheduling.AbstractScheduleActEditor;

public abstract class AbstractCalendarEventEditor
extends AbstractScheduleActEditor {
    private final ScheduleEventSeries series;
    private final ScheduleEventSeriesEditor seriesEditor;
    private final AppointmentRules rules;
    private final Label duration = LabelFactory.create();
    private int slotSize;
    private int maxDuration;
    private DateUnits maxDurationUnits;
    private static final DurationFormatter formatter = DateDurationFormatter.create((boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true);

    public AbstractCalendarEventEditor(Act act, IMObject parent, LayoutContext context) {
        this(act, parent, false, context);
    }

    public AbstractCalendarEventEditor(Act act, IMObject parent, boolean editSeries, LayoutContext context) {
        super(act, parent, context);
        Date scheduleDate;
        Date startTime;
        this.rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
        if (act.isNew()) {
            this.initParticipant("schedule", (IMObject)context.getContext().getSchedule());
        }
        if ((startTime = this.getStartTime()) == null && (scheduleDate = context.getContext().getScheduleDate()) != null) {
            startTime = this.getDefaultStartTime(scheduleDate);
            this.setStartTime(startTime, true);
        }
        if (this.getProperty("repeat") != null) {
            this.series = this.createSeries();
            if (editSeries) {
                this.seriesEditor = this.createSeriesEditor(this.series);
                this.seriesEditor.addModifiableListener(modifiable -> this.resetValid(false));
            } else {
                this.seriesEditor = null;
            }
        } else {
            this.series = null;
            this.seriesEditor = null;
        }
        this.updateRelativeDate();
        this.updateDuration();
    }

    public void setSchedule(Entity schedule) {
        if (this.setParticipant("schedule", schedule)) {
            this.onScheduleChanged(schedule);
        }
        this.calculateEndTime();
    }

    public Entity getSchedule() {
        return this.getParticipant("schedule");
    }

    public ScheduleEventSeries getSeries() {
        return this.seriesEditor != null ? this.seriesEditor.getSeries() : this.series;
    }

    public void setExpression(RepeatExpression expression) {
        if (this.seriesEditor != null) {
            this.seriesEditor.setExpression(expression);
        }
    }

    public void setCondition(RepeatCondition condition) {
        if (this.seriesEditor != null) {
            this.seriesEditor.setCondition(condition);
        }
    }

    public boolean isModified() {
        return super.isModified() || this.seriesEditor != null && this.seriesEditor.isModified();
    }

    public void clearModified() {
        super.clearModified();
        if (this.seriesEditor != null) {
            this.seriesEditor.clearModified();
        }
    }

    public List<Times> getEventTimes() {
        List<Times> result = this.seriesEditor != null ? this.series.getEventTimes() : Collections.singletonList(Times.create((Act)this.getObject()));
        return result;
    }

    protected ScheduleEventSeries createSeries() {
        return new ScheduleEventSeries(this.getObject(), (IArchetypeService)ServiceHelper.getArchetypeService());
    }

    protected ScheduleEventSeriesEditor createSeriesEditor(ScheduleEventSeries series) {
        return new ScheduleEventSeriesEditor(series);
    }

    protected AppointmentRules getRules() {
        return this.rules;
    }

    protected ScheduleEventSeriesEditor getSeriesEditor() {
        return this.seriesEditor;
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && (this.seriesEditor == null || this.seriesEditor.validate(validator));
    }

    protected boolean validateStartEndTimes(Validator validator) {
        boolean result = super.validateStartEndTimes(validator);
        if (result) {
            Date start = this.getStartTime();
            Date end = this.getEndTime();
            if (start != null && end != null) {
                Date max;
                if (start.getTime() == end.getTime()) {
                    result = false;
                    String message = Messages.format((String)"act.validation.startEqualToEnd", (Object[])new Object[]{this.getPropertyDisplayName("startTime"), this.getPropertyDisplayName("endTime")});
                    validator.add((Modifiable)this, new ValidatorError(message));
                } else if (this.maxDuration > 0 && this.maxDurationUnits != null && end.compareTo(new Date()) > 0 && end.compareTo(max = DateRules.getDate((Date)start, (int)this.maxDuration, (DateUnits)this.maxDurationUnits)) > 0) {
                    result = false;
                    String message = Messages.format((String)"workflow.scheduling.maxduration", (Object[])new Object[]{this.getDisplayName(), formatter.format(start, max)});
                    validator.add((Modifiable)this, new ValidatorError(message));
                }
            }
        }
        return result;
    }

    protected void doSave() {
        super.doSave();
        if (this.seriesEditor != null) {
            this.seriesEditor.save();
        }
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        Entity schedule = this.getSchedule();
        this.initSchedule(schedule);
        if (this.getEndTime() == null) {
            this.calculateEndTime();
        }
    }

    protected void onStartTimeChanged() {
        Date start = this.getStartTime();
        if (start != null && this.slotSize != 0) {
            Date rounded = this.rules.getSlotTime(start, this.slotSize, false);
            if (DateRules.compareTo((Date)start, (Date)rounded) != 0) {
                this.setStartTime(rounded, true);
            }
            if (this.seriesEditor != null) {
                this.seriesEditor.refresh();
            }
        }
        try {
            this.calculateEndTime();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.updateRelativeDate();
        this.updateDuration();
    }

    protected void onEndTimeChanged() {
        Date start = this.getStartTime();
        Date end = this.getEndTime();
        if (start != null && end != null) {
            Date rounded;
            if (end.compareTo(start) < 0) {
                this.calculateEndTime();
            } else if (this.slotSize != 0 && DateRules.compareTo((Date)end, (Date)(rounded = this.rules.getSlotTime(end, this.slotSize, true))) != 0) {
                this.setEndTime(rounded, true);
            }
        }
        this.updateDuration();
    }

    protected void updateRelativeDate() {
        this.getEndTimeEditor().setRelativeDate(this.getStartTime());
    }

    protected abstract void calculateEndTime();

    protected void onScheduleChanged(Entity schedule) {
        this.initSchedule(schedule);
    }

    protected void initSchedule(Entity schedule) {
        IMObjectBean bean;
        this.setSlotSize(this.getSlotSize(schedule));
        this.maxDuration = -1;
        this.maxDurationUnits = null;
        if (schedule != null && (bean = this.getBean((IMObject)schedule)).hasNode("maxDuration")) {
            this.maxDuration = bean.getInt("maxDuration", -1);
            this.maxDurationUnits = DateUnits.fromString((String)bean.getString("maxDurationUnits", null));
        }
    }

    protected int getSlotSize(Entity schedule) {
        return schedule != null ? this.rules.getSlotSize(schedule) : 0;
    }

    protected int getSlotSize() {
        return this.slotSize;
    }

    protected void setSlotSize(int slotSize) {
        this.slotSize = slotSize;
    }

    protected Date getDefaultStartTime(Date date) {
        Party schedule = (Party)this.getParticipant("schedule");
        int slotSize = this.getSlotSize((Entity)schedule);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        GregorianCalendar timeCal = new GregorianCalendar();
        timeCal.setTime(new Date());
        calendar.set(11, timeCal.get(11));
        calendar.set(12, timeCal.get(12));
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (slotSize != 0) {
            int mins = calendar.get(12);
            mins = mins / slotSize * slotSize + slotSize;
            calendar.set(12, mins);
        }
        return calendar.getTime();
    }

    private void updateDuration() {
        Date startTime = this.getStartTime();
        Date endTime = this.getEndTime();
        if (startTime != null && endTime != null) {
            this.duration.setText(formatter.format(startTime, endTime));
        } else {
            this.duration.setText(null);
        }
    }

    protected class LayoutStrategy
    extends AbstractLayoutStrategy {
        private final SimpleProperty durationProperty;

        public LayoutStrategy() {
            super(new ArchetypeNodes());
            this.durationProperty = new SimpleProperty("duration", null, String.class, Messages.get((String)"workflow.scheduling.appointment.duration"));
            this.addComponent(new ComponentState((PropertyEditor)AbstractCalendarEventEditor.this.getStartTimeEditor()));
            this.addComponent(new ComponentState((PropertyEditor)AbstractCalendarEventEditor.this.getEndTimeEditor()));
            this.addComponent(new ComponentState((Component)AbstractCalendarEventEditor.this.duration, (Property)this.durationProperty));
        }

        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            Property notes = properties.get("notes");
            if (notes != null) {
                this.addComponent(this.createMultiLineText(notes, 2, 5, new Extent(50, 128), context));
            }
            return super.apply(object, properties, parent, context);
        }

        protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context) {
            ArchetypeNodes.insertAfter(properties, (String)"endTime", (Property[])new Property[]{this.durationProperty});
            ComponentGrid grid = super.createGrid(object, properties, context);
            Property repeat = AbstractCalendarEventEditor.this.getProperty("repeat");
            if (repeat != null) {
                if (AbstractCalendarEventEditor.this.seriesEditor != null) {
                    ComponentState repeatState = new ComponentState(AbstractCalendarEventEditor.this.seriesEditor.getRepeatEditor(), repeat, AbstractCalendarEventEditor.this.seriesEditor.getRepeatFocusGroup());
                    grid.add(repeatState, 2);
                    ComponentState untilState = new ComponentState(AbstractCalendarEventEditor.this.seriesEditor.getUntilEditor(), AbstractCalendarEventEditor.this.seriesEditor.getUntilFocusGroup());
                    untilState.setLabel(new Label());
                    grid.add(new ComponentState[]{untilState});
                } else {
                    ScheduleEventSeriesViewer viewer = new ScheduleEventSeriesViewer(AbstractCalendarEventEditor.this.series);
                    grid.add(new ComponentState(viewer.getComponent(), repeat), 2);
                }
            }
            return grid;
        }
    }
}

