/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.vet;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.relationship.RelationshipStateTableModel;

public class VetRelationshipStateTableModel
extends RelationshipStateTableModel {
    private static final int PRACTICE_INDEX = 5;

    public VetRelationshipStateTableModel(LayoutContext context, boolean displayTarget) {
        super(context, displayTarget);
    }

    protected Object getValue(RelationshipState object, TableColumn column, int row) {
        Object result;
        if (column.getModelIndex() == 5) {
            Reference vet = TypeHelper.isA((Reference)object.getTarget(), (String)"party.supplierVeterinarian") ? object.getTarget() : object.getSource();
            result = vet != null ? this.getPractice(vet) : null;
        } else {
            result = super.getValue(object, column, row);
        }
        return result;
    }

    protected TableColumnModel createTableColumnModel() {
        TableColumnModel model = super.createTableColumnModel();
        model.addColumn(VetRelationshipStateTableModel.createTableColumn((int)5, (String)"supplier.vet.practice"));
        int count = model.getColumnCount();
        model.moveColumn(count - 1, count - 2);
        return model;
    }

    private Component getPractice(Reference vet) {
        ArchetypeQuery query = new ArchetypeQuery(vet);
        Date now = new Date();
        query.add((IConstraint)Constraints.join((String)"practices").add((IConstraint)Constraints.lte((String)"activeStartTime", (Object)now)).add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.gte((String)"activeEndTime", (Object)now), Constraints.isNull((String)"activeEndTime")})).add((IConstraint)Constraints.join((String)"source", (String)"practice")));
        query.add((IConstraint)Constraints.sort((String)"practice", (String)"id"));
        query.add((IConstraint)new ObjectRefSelectConstraint("practice"));
        query.add((IConstraint)new NodeSelectConstraint("practice.name"));
        query.setMaxResults(1);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator((IArchetypeQuery)query);
        if (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            return this.getEntityViewer((Reference)set.getReference("practice.reference"), set.getString("practice.name"));
        }
        return null;
    }
}

