/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.supplier.ProductOrder;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.table.CellFormat;
import org.openvpms.web.echo.table.EvenOddTableCellRenderer;
import org.openvpms.web.echo.table.TableColumnFactory;
import org.openvpms.web.resource.i18n.Messages;

public class ProductOnOrderDialog
extends ConfirmationDialog {
    private final PagedIMTable<ProductOrder> table;

    public ProductOnOrderDialog(Product product, List<ProductOrder> orders) {
        super(Messages.get((String)"supplier.order.onorder.title"), Messages.format((String)"supplier.order.onorder.message", (Object[])new Object[]{product.getName()}), YES_NO);
        if (orders.size() > 0) {
            orders.sort((o1, o2) -> {
                int result = DateRules.compareTo((Date)o1.getDate(), (Date)o2.getDate());
                if (result == 0) {
                    result = Long.compare(o1.getOrder().getId(), o2.getOrder().getId());
                }
                return result;
            });
        }
        this.table = new PagedIMTable((IMTableModel)new ProductOrderTableModel());
        this.table.setResultSet((ResultSet)new ListResultSet(orders, 5));
        this.resize("ProductOnOrderDialog.size");
    }

    protected void doLayout() {
        Label message = LabelFactory.create((boolean)true, (boolean)true);
        message.setText(this.getMessage());
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, this.table.getComponent()});
        Row row = RowFactory.create((String)"Inset.Large", (Component[])new Component[]{column});
        this.getLayout().add((Component)row);
    }

    private static class ProductOrderTableModel
    extends AbstractIMTableModel<ProductOrder> {
        private static final int ID_INDEX = 0;
        private static final int DATE_INDEX = 1;
        private static final int SUPPLIER_INDEX = 2;
        private static final int QUANTITY_INDEX = 3;
        private static final int PACKAGE_SIZE_INDEX = 4;
        private static final int PACKAGE_SIZE_UNITS = 5;

        public ProductOrderTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            EvenOddTableCellRenderer valueRender = new EvenOddTableCellRenderer(CellFormat.value());
            model.addColumn(ProductOrderTableModel.createTableColumn((int)0, (String)"table.imobject.id", (TableCellRenderer)new EvenOddTableCellRenderer(CellFormat.id())));
            model.addColumn(ProductOrderTableModel.createTableColumn((int)1, (String)"table.act.date", (TableCellRenderer)new EvenOddTableCellRenderer(CellFormat.date())));
            model.addColumn(ProductOrderTableModel.createTableColumn((int)2, (String)"supplier.type", (TableCellRenderer)valueRender));
            EvenOddTableCellRenderer integerRenderer = new EvenOddTableCellRenderer(CellFormat.integer());
            model.addColumn(ProductOrderTableModel.createTableColumn((int)3, (String)"supplier.order.onorder.quantity", (TableCellRenderer)integerRenderer));
            model.addColumn(TableColumnFactory.create((int)4, (Object)this.getDisplayName("act.supplierOrderItem", "packageSize"), (TableCellRenderer)integerRenderer));
            model.addColumn(TableColumnFactory.create((int)5, (Object)this.getDisplayName("act.supplierOrderItem", "packageUnits"), (TableCellRenderer)valueRender));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }

        protected Object getValue(ProductOrder object, TableColumn column, int row) {
            Object result;
            switch (column.getModelIndex()) {
                case 0: {
                    result = object.getOrder().getId();
                    break;
                }
                case 1: {
                    result = object.getDate();
                    break;
                }
                case 2: {
                    result = object.getSupplierName();
                    break;
                }
                case 3: {
                    result = object.getUndelivered();
                    break;
                }
                case 4: {
                    result = object.getPackageSize();
                    break;
                }
                case 5: {
                    result = this.getPackageUnits(object);
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }

        private String getPackageUnits(ProductOrder object) {
            String units = object.getPackageUnits();
            return units != null ? LookupNameHelper.getName((String)"lookup.uom", (String)units, null) : null;
        }
    }
}

