/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.app.table.TableCellRenderer;
import org.openvpms.archetype.rules.supplier.DeliveryStatus;
import org.openvpms.archetype.rules.supplier.OrderRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.act.ActHierarchyFilter;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.IMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMObjectTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.workspace.supplier.SupplierHelper;
import org.openvpms.web.workspace.supplier.delivery.OrderSelectionTableCellRenderer;
import org.openvpms.web.workspace.supplier.delivery.OrderSelectionTableModel;
import org.openvpms.web.workspace.supplier.delivery.PostedOrderQuery;

public class OrderTableBrowser
extends IMObjectTableBrowser<FinancialAct> {
    private final boolean delivery;

    public OrderTableBrowser(boolean delivery, LayoutContext context) {
        super((Query)new PostedOrderQuery(!delivery, context), (IMTableModel)new OrderSelectionTableModel(context), context);
        this.delivery = delivery;
    }

    public Party getSupplier() {
        return ((PostedOrderQuery)this.getQuery()).getSupplier();
    }

    public Party getStockLocation() {
        return ((PostedOrderQuery)this.getQuery()).getStockLocation();
    }

    public List<FinancialAct> getSelectedOrderItems() {
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        PagedModel model = (PagedModel)this.getTable().getTable().getModel();
        for (FinancialAct act : model.getSelections()) {
            if (!TypeHelper.isA((IMObject)act, (String)"act.supplierOrderItem")) continue;
            result.add(act);
        }
        return result;
    }

    protected ResultSet<FinancialAct> doQuery() {
        ResultSet set = super.doQuery();
        return new FilteredResultSet<FinancialAct>(set){
            private final Filter filter;
            {
                this.filter = new Filter();
            }

            protected void filter(FinancialAct act, List<FinancialAct> results) {
                List acts = this.filter.filter((Act)act);
                if (!acts.isEmpty()) {
                    results.add(act);
                    results.addAll(acts);
                }
            }
        };
    }

    protected PagedIMTable<FinancialAct> createTable(IMTableModel<FinancialAct> model) {
        OrderSelectionTableModel orderModel = (OrderSelectionTableModel)model;
        PagedModel pagedModel = new PagedModel(orderModel);
        PagedIMTable result = super.createTable((IMTableModel)pagedModel);
        IMTable table = result.getTable();
        OrderSelectionTableCellRenderer renderer = new OrderSelectionTableCellRenderer(orderModel);
        table.setDefaultRenderer(Object.class, (TableCellRenderer)renderer);
        table.setRolloverEnabled(false);
        table.setSelectionEnabled(false);
        return result;
    }

    private class Filter
    extends ActHierarchyFilter<FinancialAct> {
        private final OrderRules rules;

        public Filter() {
            this.rules = SupplierHelper.createOrderRules(OrderTableBrowser.this.getContext().getContext().getPractice());
        }

        protected boolean include(FinancialAct parent, List<FinancialAct> children) {
            return !children.isEmpty();
        }

        protected boolean include(FinancialAct child, FinancialAct parent, FinancialAct root) {
            DeliveryStatus status = this.rules.getDeliveryStatus(child);
            return OrderTableBrowser.this.delivery == (status != DeliveryStatus.FULL);
        }
    }

    private static class PagedModel
    extends PagedIMObjectTableModel<FinancialAct> {
        private final List<Order> orders = new ArrayList<Order>();
        private final Map<FinancialAct, Order> actsToOrders = new HashMap<FinancialAct, Order>();

        public PagedModel(OrderSelectionTableModel model) {
            super((IMObjectTableModel)model);
            model.setSelectionListener(new OrderSelectionTableModel.OrderSelectionListener(){

                @Override
                public void onSelected(FinancialAct act, int row, boolean selected) {
                    this.onSelected(act, selected);
                }
            });
        }

        public void setResultSet(ResultSet<FinancialAct> set) {
            this.orders.clear();
            this.actsToOrders.clear();
            ResultSetIterator iter = new ResultSetIterator(set);
            Order order = null;
            while (iter.hasNext()) {
                FinancialAct act = (FinancialAct)iter.next();
                if (TypeHelper.isA((IMObject)act, (String)"act.supplierOrder")) {
                    order = new Order();
                    this.orders.add(order);
                } else {
                    if (order == null) {
                        throw new IllegalStateException("Order item without associated order");
                    }
                    order.addItem(act);
                }
                this.actsToOrders.put(act, order);
            }
            super.setResultSet(set);
        }

        public Set<FinancialAct> getSelections() {
            HashSet<FinancialAct> result = new HashSet<FinancialAct>();
            for (Order order : this.orders) {
                for (FinancialAct item : order.getItems()) {
                    if (!order.isSelected(item)) continue;
                    result.add(item);
                }
            }
            return result;
        }

        protected void setPage(List<FinancialAct> objects) {
            OrderSelectionTableModel model = (OrderSelectionTableModel)this.getModel();
            super.setPage(objects);
            for (int i = 0; i < objects.size(); ++i) {
                FinancialAct act = objects.get(i);
                Order order = this.actsToOrders.get(act);
                if (order == null) continue;
                if (TypeHelper.isA((IMObject)act, (String)"act.supplierOrder") && order.isSelected()) {
                    model.setSelected(i, true);
                    continue;
                }
                if (!order.isSelected(act)) continue;
                model.setSelected(i, true);
            }
        }

        private void onSelected(FinancialAct act, boolean selected) {
            OrderSelectionTableModel model = (OrderSelectionTableModel)this.getModel();
            Order order = this.actsToOrders.get(act);
            if (TypeHelper.isA((IMObject)act, (String)"act.supplierOrder")) {
                order.setSelected(selected);
                for (FinancialAct item : order.getItems()) {
                    order.setSelected(item, selected);
                    int index = model.getObjects().indexOf(item);
                    if (index == -1) continue;
                    model.setSelected(index, selected);
                }
            } else {
                order.setSelected(act, selected);
            }
        }

        private static class Order {
            private boolean selected;
            private final Map<FinancialAct, Boolean> items = new LinkedHashMap<FinancialAct, Boolean>();

            private Order() {
            }

            public void addItem(FinancialAct item) {
                this.setSelected(item, false);
            }

            public void setSelected(boolean selected) {
                this.selected = selected;
                for (FinancialAct item : this.getItems()) {
                    this.setSelected(item, selected);
                }
            }

            public boolean isSelected() {
                return this.selected;
            }

            public void setSelected(FinancialAct item, boolean selected) {
                this.items.put(item, selected);
            }

            public boolean isSelected(FinancialAct item) {
                Boolean result = this.items.get(item);
                return result != null ? result : false;
            }

            public Collection<FinancialAct> getItems() {
                return this.items.keySet();
            }
        }
    }
}

