/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.supplier.OrderRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActEditDialog;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workspace.ActPoster;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.supplier.SupplierHelper;
import org.openvpms.web.workspace.supplier.delivery.DeliveryActions;
import org.openvpms.web.workspace.supplier.delivery.DeliveryEditor;
import org.openvpms.web.workspace.supplier.delivery.DeliveryPoster;
import org.openvpms.web.workspace.supplier.delivery.OrderSelectionBrowserDialog;
import org.openvpms.web.workspace.supplier.delivery.OrderTableBrowser;
import org.openvpms.web.workspace.supplier.order.ESCISupplierCRUDWindow;

public class DeliveryCRUDWindow
extends ESCISupplierCRUDWindow {
    private final OrderRules rules;
    private static final String INVOICE_ID = "invoice";
    private static final String REVERSE_ID = "reverse";

    public DeliveryCRUDWindow(Archetypes<FinancialAct> archetypes, Context context, HelpContext help) {
        super(archetypes, (ActActions<FinancialAct>)DeliveryActions.INSTANCE, context, help);
        this.rules = SupplierHelper.createOrderRules(context.getPractice());
    }

    @Override
    protected void onCreated(final FinancialAct act) {
        boolean delivery = TypeHelper.isA((IMObject)act, (String)"act.supplierDelivery");
        DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), this.getHelpContext());
        final OrderTableBrowser browser = new OrderTableBrowser(delivery, (LayoutContext)context);
        String displayName = this.getDisplayName((IMObject)act);
        String title = Messages.format((String)"supplier.delivery.selectorders.title", (Object[])new Object[]{displayName});
        String message = Messages.format((String)"supplier.delivery.selectorders.message", (Object[])new Object[]{displayName});
        HelpContext help = this.getHelpContext().subtopic("select");
        OrderSelectionBrowserDialog dialog = new OrderSelectionBrowserDialog(title, message, browser, help);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                DeliveryCRUDWindow.this.onCreated(act, browser);
            }
        });
        dialog.show();
    }

    protected void onPosted(FinancialAct act) {
        if (act.isA("act.supplierDelivery")) {
            this.onInvoice((Act)act);
        } else {
            this.onCredit((Act)act);
        }
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createPostButton());
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        buttons.add(INVOICE_ID, () -> this.onInvoice((Act)this.getObject()));
        buttons.add(REVERSE_ID, this::onReverse);
        buttons.add(this.createCheckInboxButton());
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        boolean editEnabled = false;
        boolean deleteEnabled = false;
        boolean postEnabled = false;
        boolean invoiceEnabled = false;
        boolean reverseEnabled = false;
        if (enable) {
            FinancialAct object = (FinancialAct)this.getObject();
            DeliveryActions operations = (DeliveryActions)this.getActions();
            editEnabled = operations.canEdit(object);
            deleteEnabled = operations.canDelete(object);
            postEnabled = operations.canPost((Act)object);
            invoiceEnabled = operations.canInvoice(object);
            reverseEnabled = !postEnabled;
        }
        buttons.setEnabled("button.edit", editEnabled);
        buttons.setEnabled("button.delete", deleteEnabled);
        buttons.setEnabled("button.post", postEnabled);
        this.enablePrintPreview(buttons, enable);
        buttons.setEnabled(INVOICE_ID, invoiceEnabled);
        buttons.setEnabled(REVERSE_ID, reverseEnabled);
    }

    protected EditDialog createEditDialog(IMObjectEditor editor) {
        return new ActEditDialog(editor, this.getContext());
    }

    protected ActPoster<FinancialAct> getActPoster(FinancialAct object) {
        HelpContext help = this.getHelpContext().subtopic("post");
        return new DeliveryPoster(object, this.createLayoutContext(help));
    }

    private void onCreated(FinancialAct act, OrderTableBrowser browser) {
        this.addParticipations(act, browser.getSupplier(), browser.getStockLocation());
        HelpContext edit = this.createEditTopic((IMObject)act);
        DeliveryEditor editor = new DeliveryEditor(act, null, this.createLayoutContext(edit));
        for (FinancialAct orderItem : browser.getSelectedOrderItems()) {
            editor.createItem(orderItem);
        }
        this.edit((IMObjectEditor)editor);
    }

    private void onInvoice(Act act) {
        final Act object = (Act)IMObjectHelper.reload((IMObject)act);
        if (object != null) {
            String title = Messages.get((String)"supplier.delivery.invoice.title");
            String message = Messages.get((String)"supplier.delivery.invoice.message");
            ConfirmationDialog dialog = new ConfirmationDialog(title, message, this.getHelpContext().subtopic(INVOICE_ID));
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    DeliveryCRUDWindow.this.invoice(object);
                }
            });
            dialog.show();
        }
    }

    private void onCredit(Act act) {
        final Act object = (Act)IMObjectHelper.reload((IMObject)act);
        if (object != null) {
            String title = Messages.get((String)"supplier.delivery.credit.title");
            String message = Messages.get((String)"supplier.delivery.credit.message");
            ConfirmationDialog dialog = new ConfirmationDialog(title, message, this.getHelpContext().subtopic("credit"));
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    DeliveryCRUDWindow.this.credit(object);
                }
            });
            dialog.show();
        }
    }

    private void onReverse() {
        final FinancialAct act = (FinancialAct)IMObjectHelper.reload((IMObject)this.getObject());
        if (act != null) {
            String message;
            String title;
            if (TypeHelper.isA((IMObject)act, (String)"act.supplierDelivery")) {
                title = Messages.get((String)"supplier.delivery.reverseDelivery.title");
                message = Messages.get((String)"supplier.delivery.reverseDelivery.message");
            } else {
                title = Messages.get((String)"supplier.delivery.reverseReturn.title");
                message = Messages.get((String)"supplier.delivery.reverseReturn.message");
            }
            ConfirmationDialog dialog = new ConfirmationDialog(title, message, this.getHelpContext().subtopic(REVERSE_ID));
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    DeliveryCRUDWindow.this.reverse(act);
                }
            });
            dialog.show();
        }
    }

    private void invoice(Act act) {
        if (this.rules.isInvoiced(act)) {
            InformationDialog.show((String)Messages.get((String)"supplier.delivery.invoiced.message"));
        } else {
            this.rules.invoiceSupplier(act);
        }
    }

    private void credit(Act act) {
        if (this.rules.isCredited(act)) {
            InformationDialog.show((String)Messages.get((String)"supplier.delivery.credited.message"));
        } else {
            this.rules.creditSupplier(act);
        }
    }

    private void reverse(FinancialAct act) {
        FinancialAct reversal = act.isA("act.supplierDelivery") ? this.rules.reverseDelivery((Act)act) : this.rules.reverseReturn(act);
        this.onSaved((Act)reversal, false);
    }
}

