/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.till;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.list.ListCellRenderer;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.till.TillBalanceQuery;
import org.openvpms.archetype.rules.finance.till.TillRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.till.CashDrawer;
import org.openvpms.web.component.im.till.CashDrawerFactory;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.print.BasicPrinterListener;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.component.print.PrinterListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.dialog.SelectionDialog;
import org.openvpms.web.echo.factory.ComponentFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.account.Reverser;
import org.openvpms.web.workspace.customer.account.payment.AdminCustomerPaymentEditDialog;
import org.openvpms.web.workspace.customer.account.payment.AdminCustomerPaymentEditor;
import org.openvpms.web.workspace.reporting.FinancialActCRUDWindow;
import org.openvpms.web.workspace.reporting.till.ClearTillDialog;
import org.openvpms.web.workspace.reporting.till.StartClearTillDialog;
import org.openvpms.web.workspace.reporting.till.TillBalanceAdjustmentEditor;
import org.openvpms.web.workspace.reporting.till.TillPaymentEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TillCRUDWindow
extends FinancialActCRUDWindow {
    private final TillRules rules = (TillRules)ServiceHelper.getBean(TillRules.class);
    private final CustomerAccountRules accountRules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
    private final UserRules userRules = (UserRules)ServiceHelper.getBean(UserRules.class);
    private FinancialAct childAct;
    static final String START_CLEAR_ID = "button.startClear";
    static final String CLEAR_ID = "button.clear";
    static final String ADJUST_ID = "button.adjust";
    static final String REVERSE_ID = "button.reverse";
    static final String TRANSFER_ID = "button.transfer";
    private static final String OPEN_DRAWER_ID = "button.openDrawer";
    private static final String TILL_BALANCE = "act.tillBalance";
    private static final Logger log = LoggerFactory.getLogger(TillCRUDWindow.class);

    public TillCRUDWindow(Context context, HelpContext help) {
        super((Archetypes<FinancialAct>)new Archetypes("act.tillBalanceAdjustment", FinancialAct.class), context, help);
    }

    public void setObject(FinancialAct object) {
        this.childAct = null;
        super.setObject((IMObject)object);
    }

    public void edit() {
        if (TypeHelper.isA((IMObject)this.childAct, (String)"act.tillBalanceAdjustment")) {
            this.editAdjustment(this.childAct);
        } else if (TypeHelper.isA((IMObject)this.childAct, (String)"act.customerAccountPayment") && this.canAdministerPayment()) {
            this.administerPayment(this.childAct);
        }
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(START_CLEAR_ID, this.action(TILL_BALANCE, this::onStartClear, "till.clear.title"));
        buttons.add(CLEAR_ID, this.action(TILL_BALANCE, this::onClear, "till.clear.title"));
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        buttons.add(ADJUST_ID, this::onAdjust);
        buttons.add(REVERSE_ID, this::onReverse);
        buttons.add("button.new", this::onNew);
        buttons.add(this.createEditButton());
        buttons.add(TRANSFER_ID, this::onTransfer);
        buttons.add(OPEN_DRAWER_ID, this::onOpenDrawer);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        boolean uncleared = false;
        boolean inProgress = false;
        boolean reverse = false;
        boolean enableEdit = false;
        boolean enableTransfer = false;
        if (enable) {
            Act act = (Act)this.getObject();
            if (TypeHelper.isA((IMObject)act, (String)TILL_BALANCE)) {
                uncleared = "UNCLEARED".equals(act.getStatus());
                inProgress = "IN_PROGRESS".equals(act.getStatus());
            }
            if (uncleared) {
                if (TypeHelper.isA((IMObject)this.childAct, (String)"act.tillBalanceAdjustment")) {
                    enableEdit = true;
                } else if (TypeHelper.isA((IMObject)this.childAct, (String)"act.customerAccountPayment") && this.canAdministerPayment()) {
                    enableEdit = true;
                }
                if (TypeHelper.isA((IMObject)this.childAct, (String[])new String[]{"act.customerAccountPayment", "act.customerAccountRefund"})) {
                    enableTransfer = true;
                }
            }
            if (inProgress) {
                if (TypeHelper.isA((IMObject)this.childAct, (String)"act.customerAccountPayment") && this.canAdministerPayment()) {
                    enableEdit = true;
                }
                reverse = TypeHelper.isA((IMObject)this.childAct, (String[])new String[]{"act.customerAccountPayment", "act.customerAccountRefund"});
            }
        }
        buttons.setEnabled(START_CLEAR_ID, uncleared);
        buttons.setEnabled(CLEAR_ID, uncleared || inProgress);
        this.enablePrintPreview(buttons, enable);
        buttons.setEnabled(ADJUST_ID, uncleared || inProgress);
        buttons.setEnabled(REVERSE_ID, reverse);
        buttons.setEnabled("button.new", inProgress);
        buttons.setEnabled("button.edit", enableEdit);
        buttons.setEnabled(TRANSFER_ID, enableTransfer);
        buttons.setEnabled(OPEN_DRAWER_ID, this.canOpenDrawer());
    }

    protected void onStartClear(final FinancialAct act) {
        IMObjectBean balanceBean = this.getBean((IMObject)act);
        Entity till = (Entity)balanceBean.getTarget("till", Entity.class);
        if (!this.rules.isClearInProgress(till)) {
            IMObjectBean tillBean = this.getBean((IMObject)till);
            BigDecimal lastFloat = tillBean.getBigDecimal("tillFloat", BigDecimal.ZERO);
            HelpContext help = this.getHelpContext().subtopic("startClear");
            final StartClearTillDialog dialog = new StartClearTillDialog(help);
            dialog.setCashFloat(lastFloat);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    TillCRUDWindow.this.rules.startClearTill(act, dialog.getCashFloat());
                    TillCRUDWindow.this.onRefresh((IMObject)act);
                }
            });
            dialog.show();
        } else {
            ErrorDialog.show((String)Messages.get((String)"till.clear.title"), (String)Messages.get((String)"till.clear.error.clearInProgress"));
        }
    }

    protected void onClear(final FinancialAct act) {
        IMObjectBean actBean = this.getBean((IMObject)act);
        Party till = (Party)actBean.getTarget("till", Party.class);
        Party location = this.getContext().getLocation();
        if (till != null && location != null) {
            boolean uncleared = "UNCLEARED".equals(act.getStatus());
            boolean inProgress = "IN_PROGRESS".equals(act.getStatus());
            HelpContext help = this.getHelpContext().subtopic("clear");
            if (uncleared) {
                if (this.rules.isClearInProgress((Entity)till)) {
                    ErrorDialog.show((String)Messages.get((String)"till.clear.title"), (String)Messages.get((String)"till.clear.error.clearInProgress"));
                } else {
                    IMObjectBean bean = this.getBean((IMObject)till);
                    BigDecimal lastFloat = bean.getBigDecimal("tillFloat", BigDecimal.ZERO);
                    final ClearTillDialog dialog = new ClearTillDialog(location, true, this.getContext(), help);
                    dialog.setCashFloat(lastFloat);
                    dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                        public void onOK() {
                            TillCRUDWindow.this.rules.clearTill(act, dialog.getCashFloat(), dialog.getAccount());
                            TillCRUDWindow.this.onRefresh((IMObject)act);
                        }
                    });
                    dialog.show();
                }
            } else if (inProgress) {
                final ClearTillDialog dialog = new ClearTillDialog(location, false, this.getContext(), help);
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        TillCRUDWindow.this.rules.clearTill(act, dialog.getAccount());
                        TillCRUDWindow.this.onRefresh((IMObject)act);
                    }
                });
                dialog.show();
            }
        }
    }

    protected void onPrint() {
        final FinancialAct object = (FinancialAct)IMObjectHelper.reload((IMObject)this.getObject());
        if (object != null) {
            try {
                IMPrinter<ObjectSet> printer = this.createTillBalanceReport(object);
                String displayName = this.getDisplayName(TILL_BALANCE);
                String title = Messages.format((String)"imobject.print.title", (Object[])new Object[]{displayName});
                HelpContext help = this.getHelpContext().subtopic("print");
                InteractiveIMPrinter iPrinter = new InteractiveIMPrinter(title, printer, this.getContext(), help);
                iPrinter.setMailContext(this.getMailContext());
                iPrinter.setListener((PrinterListener)new BasicPrinterListener(){

                    public void printed(DocumentPrinter printer) {
                        FinancialAct saved = (FinancialAct)TillCRUDWindow.this.getActions().setPrinted((Act)object);
                        if (saved != null) {
                            TillCRUDWindow.this.onSaved((IMObject)saved, false);
                        }
                    }
                });
                iPrinter.print();
            }
            catch (OpenVPMSException exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
    }

    protected void onMail() {
        FinancialAct object = (FinancialAct)IMObjectHelper.reload((IMObject)this.getObject());
        if (object != null) {
            IMPrinter<ObjectSet> printer = this.createTillBalanceReport(object);
            this.mail(printer);
        }
    }

    protected void preview(FinancialAct object) {
        IMPrinter<ObjectSet> printer = this.createTillBalanceReport(object);
        this.preview((Printer)printer);
    }

    protected void onNew() {
        String[] shortNames = new String[]{"act.customerAccountPayment", "act.customerAccountRefund"};
        Archetypes archetypes = Archetypes.create((String[])shortNames, FinancialAct.class, (String)Messages.get((String)"customer.account.createtype"));
        this.onCreate(archetypes);
    }

    protected void onAdjust() {
        this.onCreate(this.getArchetypes());
    }

    protected void onReverse() {
        FinancialAct balance = (FinancialAct)IMObjectHelper.reload((IMObject)this.getObject());
        FinancialAct act = (FinancialAct)IMObjectHelper.reload((IMObject)this.childAct);
        if (balance != null && "IN_PROGRESS".equals(balance.getStatus()) && TypeHelper.isA((IMObject)this.childAct, (String[])new String[]{"act.customerAccountPayment", "act.customerAccountRefund"})) {
            Reverser reverser = new Reverser(this.getContext().getPractice(), this.getHelpContext().subtopic("reverse"));
            reverser.reverse(act, balance, reversal -> this.onRefresh((IMObject)balance));
        }
    }

    protected void onTransfer() {
        final FinancialAct act = (FinancialAct)this.getObject();
        IMObjectBean bean = this.getBean((IMObject)act);
        Party till = (Party)bean.getTarget("till", Party.class);
        List<IMObject> tills = this.getTillsExcluding(till);
        String title = Messages.get((String)"till.transfer.title");
        String message = Messages.get((String)"till.transfer.message");
        ListBox list = new ListBox(tills.toArray());
        list.setStyleName("default");
        list.setHeight(new Extent(10, 64));
        list.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
        final SelectionDialog dialog = new SelectionDialog(title, message, list, this.getHelpContext().subtopic("transfer"));
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent e) {
                Party selected = (Party)dialog.getSelected();
                if (selected != null) {
                    TillCRUDWindow.this.doTransfer(act, TillCRUDWindow.this.childAct, selected);
                }
            }
        });
        dialog.show();
    }

    protected void onOpenDrawer() {
        CashDrawer drawer = this.getCashDrawer();
        if (drawer != null && drawer.canOpen()) {
            drawer.open();
        }
    }

    protected void onCreated(FinancialAct act) {
        FinancialAct balance = (FinancialAct)this.getObject();
        if (TypeHelper.isA((IMObject)act, (String)"act.tillBalanceAdjustment")) {
            act.setDescription(Messages.get((String)"till.adjustment.description"));
        }
        IMObjectBean actBean = this.getBean((IMObject)balance);
        Reference till = actBean.getTargetRef("till");
        IMObjectBean adjBean = this.getBean((IMObject)act);
        if (till != null) {
            adjBean.setTarget("till", till);
        }
        super.onCreated((IMObject)act);
    }

    protected IMObjectEditor createEditor(FinancialAct object, LayoutContext context) {
        FinancialAct balance = (FinancialAct)this.getObject();
        if ("CLEARED".equals(balance.getStatus())) {
            balance = null;
        }
        Object result = TypeHelper.isA((IMObject)object, (String)"act.tillBalanceAdjustment") ? new TillBalanceAdjustmentEditor(object, balance, context) : (TypeHelper.isA((IMObject)object, (String[])new String[]{"act.customerAccountPayment", "act.customerAccountRefund"}) ? new TillPaymentEditor(object, balance, context) : super.createEditor((IMObject)object, context));
        return result;
    }

    protected void onEditCompleted(IMObjectEditor editor, boolean isNew) {
        FinancialAct act = (FinancialAct)IMObjectHelper.reload((IMObject)this.getObject());
        this.setObject(act);
    }

    @Override
    protected void onChildActSelected(FinancialAct child) {
        this.childAct = child;
        this.enableButtons(this.getButtons(), this.getObject() != null);
    }

    @Override
    protected IMObjectViewer createViewer(IMObject object) {
        LayoutContext context = this.createViewLayoutContext();
        TillBalanceActLayoutStrategy layout = new TillBalanceActLayoutStrategy();
        return new IMObjectViewer(object, null, (IMObjectLayoutStrategy)layout, context);
    }

    private CashDrawer getCashDrawer() {
        CashDrawer result = null;
        Entity till = this.getContext().getTill();
        if (till != null) {
            CashDrawerFactory factory = (CashDrawerFactory)ServiceHelper.getBean(CashDrawerFactory.class);
            result = factory.create(till);
        }
        return result;
    }

    private boolean canAdministerPayment() {
        User user = this.getContext().getUser();
        return UserHelper.isAdmin((User)user) || this.userRules.canEdit(user, "act.tillBalanceAdjustment");
    }

    private void editAdjustment(FinancialAct adjustment) {
        LayoutContext context = this.createLayoutContext(this.createEditTopic((IMObject)adjustment));
        final IMObjectEditor editor = this.createEditor(adjustment, context);
        EditDialog dialog = new EditDialog(editor, this.getContext());
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                TillCRUDWindow.this.onEditCompleted(editor, false);
            }
        });
        dialog.show();
    }

    private void administerPayment(FinancialAct payment) {
        if (this.canAdministerPayment()) {
            if (this.accountRules.hasClearedTillBalance(payment)) {
                ErrorDialog.show((String)Messages.get((String)"customer.account.payment.clearedtill.title"), (String)Messages.get((String)"customer.account.payment.clearedtill.message"));
            } else {
                HelpContext edit = this.createEditTopic((IMObject)payment);
                LayoutContext context = this.createLayoutContext(edit);
                final AdminCustomerPaymentEditor editor = new AdminCustomerPaymentEditor(payment, null, context);
                editor.getComponent();
                AdminCustomerPaymentEditDialog dialog = new AdminCustomerPaymentEditDialog(editor, context.getContext());
                dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                    public void onClose(WindowPaneEvent event) {
                        TillCRUDWindow.this.onEditCompleted((IMObjectEditor)editor, false);
                    }
                });
                dialog.show();
            }
        }
    }

    private void doTransfer(FinancialAct balance, FinancialAct act, Party till) {
        try {
            TillRules rules = (TillRules)ServiceHelper.getBean(TillRules.class);
            rules.transfer((Act)balance, (Act)act, (Entity)till);
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((String)exception.getMessage(), (Throwable)exception);
        }
        this.onRefresh(this.getObject());
    }

    private List<IMObject> getTillsExcluding(Party till) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        ArchetypeQuery query = new ArchetypeQuery("party.organisationTill", true).setMaxResults(-1);
        ArrayList<IMObject> tills = new ArrayList<IMObject>(service.get((IArchetypeQuery)query).getResults());
        tills.remove(till);
        return tills;
    }

    private boolean canOpenDrawer() {
        boolean result = false;
        try {
            CashDrawer drawer = this.getCashDrawer();
            result = drawer != null && drawer.canOpen();
        }
        catch (Exception exception) {
            log.warn("Failed to determine if the drawer can be opened for the till: {}", (Object)exception.getMessage(), (Object)exception);
        }
        return result;
    }

    private IMPrinter<ObjectSet> createTillBalanceReport(FinancialAct object) {
        IPage set = new TillBalanceQuery(object, (IArchetypeService)ServiceHelper.getArchetypeService()).query();
        IMPrinterFactory factory = (IMPrinterFactory)ServiceHelper.getBean(IMPrinterFactory.class);
        Context context = this.getContext();
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator(TILL_BALANCE, context);
        return factory.createObjectSetReportPrinter((Iterable)set.getResults(), (DocumentTemplateLocator)locator, context);
    }

    private class TillBalanceActLayoutStrategy
    extends FinancialActCRUDWindow.LayoutStrategy {
        private TillBalanceActLayoutStrategy() {
        }

        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            if (!context.isEdit()) {
                DateFormat format = DateFormatter.getDateTimeFormat((boolean)false);
                int maxColumns = DateFormatter.getLength((DateFormat)format);
                this.addComponent(this.createDate("startTime", properties, maxColumns, format));
                this.addComponent(this.createDate("endTime", properties, maxColumns, format));
            }
            return super.apply(object, properties, parent, context);
        }

        private ComponentState createDate(String name, PropertySet properties, int maxColumns, DateFormat format) {
            Property property = properties.get(name);
            TextField result = BoundTextComponentFactory.create((Property)property, (int)maxColumns, (Format)format);
            result.setEnabled(false);
            ComponentFactory.setStyle((Component)result, (String)"default");
            return new ComponentState((Component)result, property);
        }
    }
}

