/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.till;

import java.util.Date;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.app.DefaultContextSwitchListener;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.act.ActAmountTableModel;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class TillActTableModel
extends ActAmountTableModel<FinancialAct> {
    private final Context context;
    private final HelpContext help;
    private int customerIndex;

    public TillActTableModel(LayoutContext context) {
        super(true, false, true, true, true);
        this.context = context.getContext();
        this.help = context.getHelpContext();
    }

    protected Object getValue(FinancialAct act, TableColumn column, int row) {
        Object result = null;
        int index = column.getModelIndex();
        if (index == 6) {
            Date date = act.getActivityStartTime();
            if (date != null) {
                result = DateFormatter.formatDateTime((Date)date);
            }
        } else if (index == this.customerIndex) {
            IMObjectBean bean = this.getBean((IMObject)act);
            if (bean.hasNode("customer")) {
                NodeDescriptor descriptor = bean.getNode("customer");
                DefaultLayoutContext layout = new DefaultLayoutContext(this.context, this.help);
                layout.setContextSwitchListener((ContextSwitchListener)DefaultContextSwitchListener.INSTANCE);
                TableComponentFactory factory = new TableComponentFactory((LayoutContext)layout);
                layout.setComponentFactory((IMObjectComponentFactory)factory);
                IMObjectProperty property = new IMObjectProperty((IMObject)act, descriptor);
                result = factory.create((Property)property, (IMObject)act).getComponent();
            }
        } else {
            result = super.getValue((Act)act, column, row);
        }
        return result;
    }

    protected TableColumnModel createColumnModel(boolean showArchetype, boolean showStatus, boolean showAmount, boolean showDescription) {
        DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(showArchetype, showStatus, showAmount, showDescription);
        this.customerIndex = this.getNextModelIndex((TableColumnModel)model);
        TableColumn column = TillActTableModel.createTableColumn((int)this.customerIndex, (String)"tillacttablemodel.customer");
        model.addColumn(column);
        if (showAmount) {
            model.moveColumn(model.getColumnCount() - 1, this.getColumnOffset((TableColumnModel)model, 8));
        }
        return model;
    }
}

