/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.till;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListCellRenderer;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.reporting.till.AbstractClearTillDialog;

public class ClearTillDialog
extends AbstractClearTillDialog {
    private final SelectField account;
    private final boolean showAmount;

    public ClearTillDialog(Party location, boolean showAmount, Context context, HelpContext help) {
        super(Messages.get((String)"till.clear.title"), help);
        this.account = this.createAccountSelector(location, context);
        this.showAmount = showAmount;
        Grid grid = GridFactory.create((int)2);
        if (showAmount) {
            this.addAmount(grid);
        }
        grid.add((Component)LabelFactory.create((String)"till.clear.account"));
        grid.add((Component)this.account);
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{grid}));
    }

    public Party getAccount() {
        return (Party)this.account.getSelectedItem();
    }

    protected void onOK() {
        if (!(this.showAmount && this.getCashFloat() == null || this.getAccount() == null)) {
            super.onOK();
        }
    }

    private SelectField createAccountSelector(Party location, Context context) {
        IMObject selected = null;
        ArrayList<IMObject> accounts = new ArrayList<IMObject>();
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)location);
        List relationships = bean.getValues("depositAccounts", EntityRelationship.class, Predicates.activeNow());
        for (EntityRelationship relationship : relationships) {
            IMObject account = IMObjectHelper.getObject((Reference)relationship.getTarget(), (Context)context);
            if (!account.isActive()) continue;
            accounts.add(account);
            if (selected == null) {
                selected = account;
                continue;
            }
            IMObjectBean defBean = IMObjectHelper.getBean((IMObject)relationship);
            if (!defBean.getBoolean("default")) continue;
            selected = account;
        }
        IMObjectSorter.sort(accounts, (String[])new String[]{"name"});
        SelectField result = SelectFieldFactory.create(accounts);
        result.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
        if (!accounts.isEmpty()) {
            if (selected != null) {
                result.setSelectedItem((Object)selected);
            } else {
                result.setSelectedIndex(0);
            }
        }
        return result;
    }
}

