/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement.reminder;

import java.util.Date;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.ObjectSelectConstraint;

public class AccountReminderQueryFactory {
    private final String[] archetypes = new String[]{"act.customerChargeReminderSMS"};
    private Date from;
    private Date to;
    private String[] statuses;
    private Location location;
    private static final String STATUS = "status";
    private static final String START_TIME = "startTime";

    public void setFrom(Date from) {
        this.from = from;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public void setStatuses(String[] statuses) {
        this.statuses = statuses;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public ArchetypeQuery createQuery() {
        String reminderAlias = "reminder";
        String chargeAlias = "charge";
        String customerAlias = "customer";
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)Constraints.shortName((String)"reminder", (String[])this.archetypes, (boolean)false));
        query.add((IConstraint)new ObjectSelectConstraint("reminder"));
        query.add((IConstraint)new ObjectSelectConstraint("charge"));
        query.add((IConstraint)new ObjectSelectConstraint("customer"));
        if (this.from != null) {
            query.add((IConstraint)Constraints.gte((String)START_TIME, (Object)this.from));
        }
        if (this.to != null) {
            query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)this.to));
        }
        if (this.statuses != null && this.statuses.length != 0) {
            query.add((IConstraint)Constraints.in((String)STATUS, (Object[])this.statuses));
        }
        JoinConstraint charge = Constraints.join((String)"source", (String)"charge");
        JoinConstraint customer = Constraints.join((String)"entity", (String)"customer");
        charge.add((IConstraint)Constraints.join((String)"customer", (String)"p_customer").add((IConstraint)customer));
        query.add((IConstraint)Constraints.join((String)"charge", (String)"r_charge").add((IConstraint)charge));
        if (this.location != null && this.location.getPracticeLocation() != null) {
            charge.add((IConstraint)Constraints.join((String)"location", (String)"l2").add((IConstraint)Constraints.eq((String)"entity", (Object)this.location.getPracticeLocation())));
        }
        query.add((IConstraint)Constraints.sort((String)"reminder", (String)START_TIME));
        query.add((IConstraint)Constraints.sort((String)"reminder", (String)"id"));
        return query;
    }
}

