/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.rules.finance.statement.Statement;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.IMObjectReportPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.print.PrinterListener;
import org.openvpms.web.echo.event.VetoListener;
import org.openvpms.web.echo.event.Vetoable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.statement.AbstractStatementProcessorListener;
import org.openvpms.web.workspace.reporting.statement.StatementProgressBarProcessor;

class StatementPrintProcessor
extends AbstractStatementProcessorListener {
    private final StatementProgressBarProcessor processor;
    private final IMPrinterFactory printerFactory;
    private final VetoListener<Vetoable> cancelListener;
    private final Context context;
    private final MailContext mailContext;
    private final HelpContext help;
    private DocumentPrinter defaultPrinter;
    private boolean updatePrinted = true;
    private static final Log log = LogFactory.getLog(StatementPrintProcessor.class);

    public StatementPrintProcessor(StatementProgressBarProcessor processor, IMPrinterFactory printerFactory, VetoListener<Vetoable> cancelListener, Party practice, Context context, MailContext mailContext, HelpContext help, CommunicationLogger logger) {
        super(practice, logger);
        this.processor = processor;
        this.printerFactory = printerFactory;
        this.cancelListener = cancelListener;
        this.context = context;
        this.mailContext = mailContext;
        this.help = help;
    }

    public void setUpdatePrinted(boolean update) {
        this.updatePrinted = update;
    }

    public void process(Statement statement) {
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator("act.customerAccountOpeningBalance", this.context);
        Iterable acts = statement.getActs();
        IMObjectReportPrinter printer = this.printerFactory.createIMObjectReportPrinter(acts, (DocumentTemplateLocator)locator, this.context);
        printer.setParameters(this.getParameters(statement));
        this.print((IMObjectReportPrinter<FinancialAct>)printer, statement);
    }

    protected void print(IMObjectReportPrinter<FinancialAct> printer, final Statement statement) {
        String title = Messages.get((String)"reporting.statements.print.customer");
        InteractiveIMPrinter iPrinter = new InteractiveIMPrinter(title, printer, this.context, this.help);
        if (this.defaultPrinter != null) {
            iPrinter.setInteractive(false);
        }
        iPrinter.setCancelListener(this.cancelListener);
        iPrinter.setMailContext(this.mailContext);
        iPrinter.setListener(new PrinterListener(){

            public void printed(DocumentPrinter printer) {
                try {
                    if (StatementPrintProcessor.this.updatePrinted && !statement.isPreview() && !statement.isPrinted()) {
                        StatementPrintProcessor.this.setPrinted(statement);
                    }
                    StatementPrintProcessor.this.defaultPrinter = printer;
                    StatementPrintProcessor.this.log(statement);
                    StatementPrintProcessor.this.processor.processCompleted(statement.getCustomer());
                    StatementPrintProcessor.this.processor.process();
                }
                catch (OpenVPMSException exception) {
                    log.error((Object)exception, (Throwable)exception);
                    StatementPrintProcessor.this.processor.processFailed(statement.getCustomer(), exception.getMessage(), (Throwable)exception);
                }
            }

            public void cancelled() {
                StatementPrintProcessor.this.processor.setStatus(null);
            }

            public void skipped() {
            }

            public void failed(Throwable cause) {
                log.error((Object)cause, cause);
                StatementPrintProcessor.this.processor.processFailed(statement.getCustomer(), cause.getMessage(), cause);
            }
        });
        this.processor.setSuspend(true);
        iPrinter.print(this.defaultPrinter);
    }

    protected void log(Statement statement) {
        CommunicationLogger logger = this.getLogger();
        if (logger != null) {
            List contacts = statement.getContacts();
            Contact contact = (Contact)IterableUtils.find((Iterable)contacts, object -> object.isA("contact.location"));
            String address = contact != null ? contact.getDescription() : null;
            String subject = Messages.get((String)"reporting.statements.print.log.subject");
            logger.logMail(statement.getCustomer(), null, address, subject, "STATEMENT", null, null, this.context.getLocation());
        }
    }
}

