/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.archetype.rules.finance.statement.Statement;
import org.openvpms.archetype.rules.finance.statement.StatementProcessorException;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.service.archetype.ArchetypeServiceException;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.im.report.Reporter;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.im.report.TemplatedReporter;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.component.mail.Mailer;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.email.LocationMailerFactory;
import org.openvpms.web.workspace.reporting.statement.AbstractStatementProcessorListener;

public class StatementEmailProcessor
extends AbstractStatementProcessorListener {
    private final LocationMailerFactory mailerFactory;
    private final EmailTemplateEvaluator evaluator;
    private final ReporterFactory reporterFactory;
    private final Party practice;
    private final Party location;
    private final IArchetypeService service;
    private final DocumentTemplate statementTemplate;
    private final EmailTemplate emailTemplate;

    public StatementEmailProcessor(MailerFactory mailerFactory, EmailTemplateEvaluator evaluator, ReporterFactory reporterFactory, Party practice, Party location, PracticeRules practiceRules, IArchetypeService service, CommunicationLogger logger, MailPasswordResolver passwordResolver) {
        super(practice, logger);
        this.mailerFactory = new LocationMailerFactory(practice, practiceRules, (ArchetypeService)service, mailerFactory, "BILLING", passwordResolver);
        this.evaluator = evaluator;
        this.reporterFactory = reporterFactory;
        this.practice = practice;
        this.location = location;
        this.service = service;
        Entity entity = this.getStatementTemplate(service);
        this.statementTemplate = new DocumentTemplate(entity, (ArchetypeService)service);
        this.emailTemplate = this.statementTemplate.getEmailTemplate();
        if (this.emailTemplate == null) {
            throw new StatementProcessorException(StatementProcessorException.ErrorCode.InvalidConfiguration, new Object[]{"No email document template configured"});
        }
    }

    public void process(Statement statement) {
        try {
            CommunicationLogger logger;
            Party customer = statement.getCustomer();
            Party location = this.getLocation(customer);
            LocalContext context = new LocalContext();
            context.setCustomer(customer);
            context.setLocation(location);
            context.setPractice(this.practice);
            Mailer mailer = this.mailerFactory.create(location, (Context)context);
            List contacts = statement.getContacts();
            if (contacts.isEmpty()) {
                throw new StatementProcessorException(StatementProcessorException.ErrorCode.NoContact, new Object[]{customer});
            }
            Contact contact = (Contact)contacts.get(0);
            IMObjectBean bean = this.service.getBean((IMObject)contact);
            if (!bean.isA(new String[]{"contact.email"})) {
                throw new StatementProcessorException(StatementProcessorException.ErrorCode.NoContact, new Object[]{customer});
            }
            String to = bean.getString("emailAddress");
            String[] toAddresses = new String[]{to};
            mailer.setTo(toAddresses);
            String subject = this.evaluator.getSubject(this.emailTemplate, (Object)customer, (Context)context);
            String text = this.evaluator.getMessage(this.emailTemplate, (Object)customer, (Context)context);
            mailer.setSubject(subject);
            mailer.setBody(text);
            Iterable<IMObject> objects = this.getActs(statement);
            Reporter reporter = this.reporterFactory.create(objects, this.statementTemplate, TemplatedReporter.class);
            reporter.setParameters(this.getParameters(statement));
            reporter.setFields(ReportContextFactory.create((Context)context));
            Document doc = reporter.getDocument("application/pdf", true);
            mailer.addAttachment(doc);
            for (DocumentTemplate template : this.emailTemplate.getAttachments(true)) {
                Document document = template.getDocument();
                if (document == null) continue;
                mailer.addAttachment(document);
            }
            mailer.send();
            if (!statement.isPreview() && !statement.isPrinted()) {
                this.setPrinted(statement);
            }
            if ((logger = this.getLogger()) != null) {
                logger.logEmail(customer, null, mailer.getFrom(), toAddresses, null, null, subject, "STATEMENT", text, null, doc.getName(), location);
            }
        }
        catch (StatementProcessorException | ArchetypeServiceException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new StatementProcessorException(exception, StatementProcessorException.ErrorCode.FailedToProcessStatement, new Object[]{exception.getMessage()});
        }
    }

    protected Entity getStatementTemplate(IArchetypeService service) {
        TemplateHelper helper = new TemplateHelper((ArchetypeService)service);
        Entity entity = helper.getTemplateForType("act.customerAccountOpeningBalance");
        if (entity == null) {
            throw new StatementProcessorException(StatementProcessorException.ErrorCode.InvalidConfiguration, new Object[]{"No document template configured"});
        }
        return entity;
    }

    protected Party getLocation(Party customer) {
        Party result = (Party)this.service.getBean((IMObject)customer).getTarget("practice", Party.class);
        return result != null ? result : this.location;
    }

    private Iterable<IMObject> getActs(Statement event) {
        return event.getActs();
    }
}

