/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.report;

import java.util.List;
import javax.sql.DataSource;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ReloadingContext;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.print.PrinterContextFactory;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.DefaultIMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.AbstractReportingWorkspace;
import org.openvpms.web.workspace.reporting.report.InteractiveSQLReportPrinter;
import org.openvpms.web.workspace.reporting.report.ReportQuery;
import org.openvpms.web.workspace.reporting.report.SQLReportPrinter;

public class ReportingWorkspace
extends AbstractReportingWorkspace<Entity> {
    private final User user = this.getContext().getUser();
    private Browser<Entity> browser;
    private static final String RUN_ID = "run";

    public ReportingWorkspace(Context context, MailContext mailContext) {
        super("reporting.report", Entity.class, context, mailContext);
    }

    @Override
    protected void doLayout(Component container, FocusGroup group) {
        if (this.user != null) {
            this.layoutWorkspace(this.user, container);
        }
    }

    protected boolean refreshWorkspace() {
        User user = this.getContext().getUser();
        return !IMObjectHelper.isSame((IMObject)this.user, (IMObject)(user = (User)IMObjectHelper.reload((IMObject)user)));
    }

    protected void layoutWorkspace(User user, Component container) {
        ReportQuery query = this.createQuery(user);
        this.browser = this.createBrowser(query);
        this.browser.addBrowserListener((BrowserListener)new BrowserListener<Entity>(){

            public void query() {
                ReportingWorkspace.this.selectFirst();
            }

            public void selected(Entity object) {
                ReportingWorkspace.this.setObject(object);
            }

            public void browsed(Entity object) {
                ReportingWorkspace.this.setObject(object);
            }
        });
        container.add(this.browser.getComponent());
        if (!query.isAuto()) {
            this.browser.query();
        }
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(RUN_ID, this::onRun);
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(RUN_ID, enable);
    }

    protected void onRun() {
        Entity entity = (Entity)this.getObject();
        if (entity != null) {
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            LookupService lookups = ServiceHelper.getLookupService();
            DocumentTemplate template = new DocumentTemplate(entity, (ArchetypeService)service);
            Context context = this.getContext();
            ReportFactory factory = (ReportFactory)ServiceHelper.getBean(ReportFactory.class);
            FileNameFormatter formatter = (FileNameFormatter)ServiceHelper.getBean(FileNameFormatter.class);
            DataSource dataSource = (DataSource)ServiceHelper.getBean((String)"reportingDataSource", DataSource.class);
            PrinterContext printerContext = ((PrinterContextFactory)ServiceHelper.getBean(PrinterContextFactory.class)).create();
            SQLReportPrinter printer = new SQLReportPrinter(template, context, factory, formatter, dataSource, printerContext);
            HelpContext help = this.getHelpContext().subtopic(RUN_ID);
            MacroVariables variables = new MacroVariables((Context)new ReloadingContext(context), (ArchetypeService)service, lookups);
            InteractiveSQLReportPrinter iPrinter = new InteractiveSQLReportPrinter(printer, context, this.getMailContext(), help, (Variables)variables);
            iPrinter.print();
        }
    }

    private Browser<Entity> createBrowser(ReportQuery query) {
        DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), this.getHelpContext());
        DefaultDescriptorTableModel model = new DefaultDescriptorTableModel(query.getShortNames(), (LayoutContext)context, new String[]{"id", "name", "description", "reportType"});
        return new DefaultIMObjectTableBrowser((Query)query, (IMTableModel)model, (LayoutContext)context);
    }

    private ReportQuery createQuery(User user) {
        return new ReportQuery((Entity)user);
    }

    private void selectFirst() {
        List objects = this.browser.getObjects();
        if (!objects.isEmpty()) {
            Entity current = (Entity)objects.get(0);
            this.browser.setSelected((Object)current);
            this.setObject(current);
        } else {
            this.setObject(null);
        }
    }
}

