/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.List;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.workspace.reporting.ReportingException;

public class ReminderSMSEvaluator {
    private final SMSTemplateEvaluator evaluator;

    public ReminderSMSEvaluator(SMSTemplateEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public String evaluate(Entity template, Act reminder, Party customer, Party patient, Party location, Party practice) {
        String result;
        LocalContext local = new LocalContext();
        local.setCustomer(customer);
        local.setPatient(patient);
        local.setLocation(location);
        local.setPractice(practice);
        try {
            result = this.evaluator.evaluate(template, (Object)reminder, (Context)local);
        }
        catch (Throwable exception) {
            throw new ReportingException(ReportingException.ErrorCode.SMSEvaluationFailed, exception, template.getName());
        }
        return result;
    }

    public String evaluate(Entity template, List<ObjectSet> reminders, Party customer, Party patient, Party location, Party practice) {
        String result;
        LocalContext local = new LocalContext();
        local.setCustomer(customer);
        local.setPatient(patient);
        local.setLocation(location);
        local.setPractice(practice);
        try {
            result = this.evaluator.evaluate(template, reminders, (Context)local);
        }
        catch (Throwable exception) {
            throw new ReportingException(ReportingException.ErrorCode.SMSEvaluationFailed, exception, template.getName());
        }
        return result;
    }
}

