/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Iterator;
import org.openvpms.archetype.rules.patient.reminder.PagedReminderItemIterator;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.system.ServiceHelper;

abstract class ReminderItemProgressBarProcessor
extends ProgressBarProcessor<ObjectSet> {
    public ReminderItemProgressBarProcessor(ReminderItemQueryFactory factory) {
        super(null);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        ArchetypeQuery query = factory.createQuery();
        query.setMaxResults(0);
        query.setCountResults(true);
        int size = service.get((IArchetypeQuery)query).getTotalResults();
        this.setItems((Iterator)new PagedReminderItemIterator(factory, 100, (IArchetypeService)service), size);
    }

    protected void process(ObjectSet object) {
        Act item = (Act)object.get("item");
        Act reminder = (Act)object.get("reminder");
        this.process(item, reminder);
        this.processCompleted(object);
    }

    protected abstract void process(Act var1, Act var2);

    protected void updated() {
        this.getIterator().updated();
    }

    protected PagedReminderItemIterator getIterator() {
        return (PagedReminderItemIterator)super.getIterator();
    }
}

