/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import echopointng.DateField;
import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.bound.BoundCheckBox;
import org.openvpms.web.component.bound.BoundDateFieldFactory;
import org.openvpms.web.component.im.query.QueryState;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ComponentHelper;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemObjectSetQuery;

public class ReminderItemDateObjectSetQuery
extends ReminderItemObjectSetQuery {
    private final SimpleProperty all;
    private final SimpleProperty date = new SimpleProperty("date", null, Date.class, DescriptorHelper.getDisplayName((String)"act.patientReminderItemPrint", (String)"startTime", (ArchetypeService)this.getService()));
    private final ModifiableListener dateListener;
    private final Label dateLabel;
    private final DateField dateField;
    private ModifiableListener allListener;

    public ReminderItemDateObjectSetQuery(String status, Context context) {
        this(status, false, context);
    }

    public ReminderItemDateObjectSetQuery(String status, boolean all, Context context) {
        super(status, context);
        this.date.setValue((Object)DateRules.getToday());
        this.dateLabel = LabelFactory.create();
        this.dateLabel.setText(this.date.getDisplayName());
        this.dateField = BoundDateFieldFactory.create((Property)this.date);
        if (all) {
            this.all = new SimpleProperty("all", (Object)true, Date.class, Messages.get((String)"daterange.all"));
            this.allListener = modifiable -> this.onAllChanged();
            this.all.addModifiableListener(this.allListener);
            this.enableDate();
        } else {
            this.all = null;
        }
        this.dateListener = modifiable -> this.onQuery();
        this.date.addModifiableListener(this.dateListener);
    }

    public QueryState getQueryState() {
        return new Memento(this);
    }

    @Override
    public void setQueryState(QueryState state) {
        super.setQueryState(state);
        if (state instanceof Memento) {
            Memento memento = (Memento)state;
            this.setDate(memento.date);
            this.setAll(memento.all);
        }
    }

    @Override
    protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
        Date to;
        if (this.all == null && (to = this.date.getDate()) == null) {
            to = DateRules.getToday();
            this.setDate(to);
        }
        return super.createResultSet(sort);
    }

    @Override
    protected void doLayout(Component container) {
        super.doLayout(container);
        if (this.all != null) {
            Label allLabel = LabelFactory.create();
            allLabel.setText(this.all.getDisplayName());
            container.add((Component)allLabel);
            container.add((Component)new BoundCheckBox((Property)this.all));
        }
        container.add((Component)this.dateLabel);
        container.add((Component)this.dateField);
        this.addLocationSelector(container);
    }

    @Override
    protected void populate(ReminderItemQueryFactory factory) {
        super.populate(factory);
        factory.setFrom(null);
        if (this.all != null && this.all.getBoolean()) {
            factory.setTo(null);
        } else {
            Date to = this.date.getDate();
            factory.setTo(DateRules.getNextDate((Date)to));
        }
    }

    private void setDate(Date date) {
        this.date.removeModifiableListener(this.dateListener);
        this.date.setValue((Object)date);
        this.date.addModifiableListener(this.dateListener);
    }

    private void setAll(boolean all) {
        if (this.all != null) {
            this.all.removeModifiableListener(this.allListener);
            this.all.setValue((Object)all);
            this.all.addModifiableListener(this.allListener);
        }
    }

    private void onAllChanged() {
        this.enableDate();
        this.onQuery();
    }

    private void enableDate() {
        boolean enable = this.all != null && !this.all.getBoolean();
        ComponentHelper.enable((Component)this.dateLabel, (boolean)enable);
        ComponentHelper.enable((DateField)this.dateField, (boolean)enable);
    }

    private static class Memento
    extends ReminderItemObjectSetQuery.AbstractMemento {
        private final Date date;
        private boolean all;

        public Memento(ReminderItemDateObjectSetQuery query) {
            super(query);
            this.date = query.date.getDate();
            this.all = query.all != null && query.all.getBoolean();
        }
    }
}

