/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderExporter;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.echo.servlet.DownloadServlet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;

public class ReminderExportProcessor
extends PatientReminderProcessor<PatientReminders> {
    private final Party location;

    public ReminderExportProcessor(ReminderTypes reminderTypes, ReminderRules rules, PatientRules patientRules, Party location, Party practice, IArchetypeService service, ReminderConfiguration config, CommunicationLogger logger, ActionFactory actionFactory) {
        super(reminderTypes, rules, patientRules, practice, (ArchetypeService)service, config, logger, actionFactory);
        this.location = location;
    }

    @Override
    public String getArchetype() {
        return "act.patientReminderItemExport";
    }

    @Override
    public void process(PatientReminders reminders) {
        this.export(reminders.getReminders());
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }

    protected void export(List<ReminderEvent> reminders) {
        ReminderExporter exporter = (ReminderExporter)ServiceHelper.getBean(ReminderExporter.class);
        Document document = exporter.export(reminders, new Date());
        DownloadServlet.startDownload((Document)document);
    }

    @Override
    protected PatientReminders createPatientReminders(ReminderType.GroupBy groupBy, boolean resend) {
        return new PatientReminders(groupBy, resend);
    }

    @Override
    protected void prepare(PatientReminders reminders) {
        for (ReminderEvent reminder : reminders.getReminders()) {
            ContactMatcher matcher;
            Party customer = reminder.getCustomer();
            Contact contact = this.getContact(customer, matcher = this.createContactMatcher("contact.location"), reminder.getContact());
            if (contact != null) {
                this.populate(reminder, contact, this.getLocation(customer));
                continue;
            }
            String message = Messages.format((String)"reporting.reminder.nocontact", (Object[])new Object[]{DescriptorHelper.getDisplayName((String)"contact.location", (ArchetypeService)this.getService())});
            this.error(reminder, message, reminders);
        }
    }

    @Override
    protected void log(PatientReminders state, CommunicationLogger logger) {
        List<ReminderEvent> reminders = state.getReminders();
        String subject = Messages.get((String)"reminder.log.export.subject");
        for (ReminderEvent reminder : reminders) {
            Contact contact = reminder.getContact();
            String notes = this.getNote(reminder);
            logger.logMail(reminder.getCustomer(), reminder.getPatient(), contact.getDescription(), subject, "PATIENT_REMINDER", null, notes, this.location);
        }
    }
}

