/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.component.mail.Mailer;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.openvpms.web.workspace.customer.communication.CommunicationHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.ReportingException;
import org.openvpms.web.workspace.reporting.email.LocationMailerFactory;
import org.openvpms.web.workspace.reporting.reminder.EmailReminders;
import org.openvpms.web.workspace.reporting.reminder.GroupedReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;

public class ReminderEmailProcessor
extends GroupedReminderProcessor<EmailReminders> {
    private final LocationMailerFactory mailServices;
    private final EmailTemplateEvaluator evaluator;
    private final ReporterFactory reporterFactory;

    public ReminderEmailProcessor(MailerFactory factory, EmailTemplateEvaluator evaluator, ReporterFactory reporterFactory, ReminderTypes reminderTypes, Party practice, ReminderRules reminderRules, PatientRules patientRules, PracticeRules practiceRules, IArchetypeService service, ReminderConfiguration config, CommunicationLogger logger, MailPasswordResolver passwordResolver, ActionFactory actionFactory) {
        super(reminderTypes, reminderRules, patientRules, practice, (ArchetypeService)service, config, logger, actionFactory);
        this.evaluator = evaluator;
        this.reporterFactory = reporterFactory;
        this.mailServices = new LocationMailerFactory(practice, practiceRules, (ArchetypeService)service, factory, "REMINDER", passwordResolver);
    }

    @Override
    public String getArchetype() {
        return "act.patientReminderItemEmail";
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }

    @Override
    public void process(EmailReminders reminders) {
        Mailer mailer;
        try {
            mailer = this.send(reminders);
        }
        catch (OpenVPMSException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new ReportingException(ReportingException.ErrorCode.FailedToProcessReminder, exception, exception.getMessage());
        }
        if (this.getLogger() != null) {
            String from = mailer.getFrom();
            String[] to = mailer.getTo();
            String[] cc = mailer.getCc();
            String[] bcc = mailer.getBcc();
            String subject = mailer.getSubject();
            String body = mailer.getBody();
            String attachments = CommunicationHelper.getAttachments(mailer.getAttachments());
            for (ReminderEvent reminder : reminders.getReminders()) {
                reminder.set("from", (Object)from);
                reminder.set("to", (Object)to);
                reminder.set("cc", (Object)cc);
                reminder.set("bcc", (Object)bcc);
                reminder.set("subject", (Object)subject);
                reminder.set("body", (Object)body);
                reminder.set("attachments", (Object)attachments);
            }
        }
    }

    @Override
    protected void prepare(EmailReminders reminders) {
        super.prepare(reminders);
        DocumentTemplate template = reminders.getTemplate();
        if (template != null) {
            EmailTemplate emailTemplate = template.getEmailTemplate();
            if (emailTemplate == null) {
                throw new ReportingException(ReportingException.ErrorCode.TemplateMissingEmailText, template.getName());
            }
            reminders.setEmailTemplate(emailTemplate);
        }
    }

    @Override
    protected EmailReminders createPatientReminders(ReminderType.GroupBy groupBy, boolean resend) {
        return new EmailReminders(groupBy, resend, this.evaluator, this.reporterFactory);
    }

    @Override
    protected String getContactArchetype() {
        return "contact.email";
    }

    @Override
    protected void log(PatientReminders reminders, CommunicationLogger logger) {
        Party location = ((EmailReminders)reminders).getLocation();
        for (ReminderEvent event : reminders.getReminders()) {
            String notes = this.getNote(event);
            String from = event.getString("from");
            String[] to = (String[])event.get("to");
            String[] cc = (String[])event.get("cc");
            String[] bcc = (String[])event.get("bcc");
            String subject = event.getString("subject");
            String body = event.getString("body");
            String attachments = event.getString("attachments");
            logger.logEmail(event.getCustomer(), event.getPatient(), from, to, cc, bcc, subject, "PATIENT_REMINDER", body, notes, attachments, location);
        }
    }

    protected Mailer send(EmailReminders reminders) {
        ReminderEvent event = reminders.getReminders().get(0);
        Party location = reminders.getLocation();
        if (location == null) {
            throw new IllegalStateException("Practice location cannot be null, reminder=" + event.getReminder().getId());
        }
        Context context = this.createContext(event, location);
        Mailer mailer = this.mailServices.create(location, context);
        String body = reminders.getMessage(context);
        String to = reminders.getEmailAddress();
        mailer.setTo(new String[]{to});
        String subject = reminders.getSubject(context);
        mailer.setSubject(subject);
        mailer.setBody(body);
        ReminderConfiguration config = this.getConfig();
        if (config.getEmailAttachments()) {
            Document document = reminders.createAttachment(context);
            mailer.addAttachment(document);
        }
        for (DocumentTemplate template : reminders.getEmailTemplate().getAttachments(true)) {
            Document document = template.getDocument();
            if (document == null) continue;
            mailer.addAttachment(document);
        }
        mailer.send();
        return mailer;
    }
}

