/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import org.openvpms.component.business.service.scheduler.JobScheduler;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemBrowser;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemQuery;

class PendingReminderItemBrowser
extends ReminderItemBrowser {
    public PendingReminderItemBrowser(ReminderItemQuery query, LayoutContext context) {
        super(query, context);
    }

    @Override
    protected Browser<ObjectSet> createBrowser(ReminderItemQuery query, LayoutContext context) {
        return new PendingReminderItemObjectSetBrowser(query, context);
    }

    private static class PendingReminderItemObjectSetBrowser
    extends ReminderItemBrowser.ReminderItemObjectSetBrowser {
        private Label label = LabelFactory.create(null, (boolean)true);

        public PendingReminderItemObjectSetBrowser(ReminderItemQuery query, LayoutContext context) {
            super((Query<ObjectSet>)query.getQuery(), context);
            this.label.setStyleName("bold");
            this.label.setLayoutData((LayoutData)ColumnFactory.layout((Alignment)Alignment.ALIGN_CENTER));
        }

        protected void doLayout(Component container, boolean hasResults) {
            super.doLayout(container, hasResults);
            if (!hasResults) {
                JobScheduler scheduler = (JobScheduler)ServiceHelper.getBean(JobScheduler.class);
                List jobs = scheduler.getJobs("entity.jobPatientReminderQueue");
                if (jobs.isEmpty()) {
                    this.label.setText(Messages.get((String)"reporting.reminder.send.nojob"));
                } else {
                    Entity configuration = (Entity)jobs.get(0);
                    Date date = scheduler.getNextRunTime(configuration);
                    if (date == null) {
                        this.label.setText(Messages.format((String)"reporting.reminder.send.notscheduled", (Object[])new Object[]{configuration.getName()}));
                    } else {
                        this.label.setText(Messages.format((String)"reporting.reminder.send.scheduled", (Object[])new Object[]{DateFormatter.formatDateTimeAbbrev((Date)date)}));
                    }
                }
            }
        }

        protected void doLayoutForNoResults(Component container) {
            Column wrapper = ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{this.label});
            wrapper.setLayoutData((LayoutData)SplitPaneFactory.layout((Alignment)Alignment.ALIGN_CENTER));
            container.add((Component)wrapper);
        }
    }
}

