/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.party.PurposeMatcher;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.action.ListCallBuilder;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.openvpms.web.workspace.reporting.reminder.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PatientReminderProcessor<T extends PatientReminders> {
    protected static final String CONTACT_PURPOSE = "REMINDER";
    protected static final String COMMUNICATION_REASON = "PATIENT_REMINDER";
    private final Party practice;
    private final ReminderTypes reminderTypes;
    private final ReminderRules reminderRules;
    private final PatientRules patientRules;
    private final ArchetypeService service;
    private final ReminderConfiguration config;
    private final CommunicationLogger logger;
    private final ActionFactory actionFactory;
    private static final Logger log = LoggerFactory.getLogger(PatientReminderProcessor.class);

    public PatientReminderProcessor(ReminderTypes reminderTypes, ReminderRules reminderRules, PatientRules patientRules, Party practice, ArchetypeService service, ReminderConfiguration config, CommunicationLogger logger, ActionFactory actionFactory) {
        this.reminderTypes = reminderTypes;
        this.reminderRules = reminderRules;
        this.patientRules = patientRules;
        this.practice = practice;
        this.service = service;
        this.config = config;
        this.logger = logger;
        this.actionFactory = actionFactory;
    }

    public T prepare(List<ReminderEvent> reminders, ReminderType.GroupBy groupBy, Date cancelDate, boolean resend) {
        T result = this.createPatientReminders(groupBy, resend);
        for (ReminderEvent reminder : reminders) {
            Act item = reminder.getItem();
            if (!resend && this.isOutOfDate(item, cancelDate)) {
                this.cancel(reminder, Messages.get((String)"reporting.reminder.outofdate"), false, (PatientReminders)result);
                continue;
            }
            if (this.isReminderTypeInactive(reminder)) {
                this.cancel(reminder, Messages.get((String)"reporting.reminder.remindertypeinactive"), resend, (PatientReminders)result);
                continue;
            }
            if (this.isDeceased(reminder)) {
                this.cancel(reminder, Messages.get((String)"reporting.reminder.deceased"), resend, (PatientReminders)result);
                continue;
            }
            if (this.isPatientInactive(reminder)) {
                this.cancel(reminder, Messages.get((String)"reporting.reminder.patientinactive"), resend, (PatientReminders)result);
                continue;
            }
            if (this.isCustomerInactive(reminder)) {
                this.cancel(reminder, Messages.get((String)"reporting.reminder.customerinactive"), resend, (PatientReminders)result);
                continue;
            }
            ((PatientReminders)result).addReminder(reminder);
        }
        this.prepare(result);
        return result;
    }

    public abstract String getArchetype();

    public abstract void process(T var1);

    public boolean complete(T reminders) {
        boolean resend = ((PatientReminders)reminders).getResend();
        for (ReminderEvent reminder : ((PatientReminders)reminders).getReminders()) {
            if (!resend) {
                this.complete(reminder, (PatientReminders)reminders);
                continue;
            }
            Act item = reminder.getItem();
            if (!item.isNew() || "ERROR".equals(item.getStatus())) continue;
            this.completeItem(reminder);
            ((PatientReminders)reminders).addUpdated(reminder, item);
        }
        boolean result = this.save((PatientReminders)reminders);
        CommunicationLogger logger = this.getLogger();
        if (logger != null && !((PatientReminders)reminders).getReminders().isEmpty()) {
            this.log((PatientReminders)reminders, logger);
        }
        return result;
    }

    public boolean failed(PatientReminders reminders, Throwable exception) {
        MutableBoolean result = new MutableBoolean();
        boolean resend = reminders.getResend();
        log.error("Failed to send reminders: {}", (Object)exception.getMessage(), (Object)exception);
        if (!resend) {
            String error = ErrorFormatter.format((Throwable)exception);
            for (ReminderEvent reminder : reminders.getUnsaved()) {
                reminders.addError(reminder);
                this.updateFailed(reminder, error);
                result.setValue(true);
            }
        }
        return result.booleanValue();
    }

    public void addStatistics(PatientReminders reminders, Statistics statistics) {
        for (ReminderEvent event : reminders.getReminders()) {
            ReminderType reminderType = this.reminderTypes.get(event.getReminderType());
            if (reminderType == null) continue;
            statistics.increment(event, reminderType);
        }
        statistics.addErrors(reminders.getErrors().size());
        statistics.addCancelled(reminders.getCancelled().size());
    }

    public abstract boolean isAsynchronous();

    public ReminderTypes getReminderTypes() {
        return this.reminderTypes;
    }

    protected abstract T createPatientReminders(ReminderType.GroupBy var1, boolean var2);

    protected abstract void prepare(T var1);

    protected void cancel(ReminderEvent reminder, String message, boolean resend, PatientReminders reminders) {
        Act item = reminder.getItem();
        this.updateItem(item, "CANCELLED", message);
        if (!resend) {
            ArrayList<Act> toSave = new ArrayList<Act>();
            toSave.add(item);
            Act act = this.updateReminder(reminder, item);
            if (act != null) {
                toSave.add(act);
            }
            reminders.addUpdated(reminder, toSave);
        }
        reminders.addCancelled(reminder);
    }

    protected boolean isOutOfDate(Act item, Date from) {
        Date cancel = this.config.getCancelDate(item.getActivityStartTime(), this.getArchetype());
        return DateRules.compareDates((Date)cancel, (Date)from) <= 0;
    }

    protected boolean isDeceased(ReminderEvent reminder) {
        Party patient = reminder.getPatient();
        return patient != null && this.patientRules.isDeceased(patient);
    }

    protected boolean isPatientInactive(ReminderEvent reminder) {
        Party patient = reminder.getPatient();
        return patient == null || !patient.isActive();
    }

    protected boolean isCustomerInactive(ReminderEvent reminder) {
        Party customer = reminder.getCustomer();
        return customer == null || !customer.isActive();
    }

    protected abstract void log(PatientReminders var1, CommunicationLogger var2);

    protected boolean save(PatientReminders reminders) {
        boolean result = false;
        Map<ReminderEvent, List<Act>> updated = reminders.getUpdated();
        if (!updated.isEmpty()) {
            for (Map.Entry<ReminderEvent, List<Act>> entry : updated.entrySet()) {
                ReminderEvent reminder = entry.getKey();
                ((ListCallBuilder)this.actionFactory.newAction().backgroundOnly().withObjects(entry.getValue()).failIfChangedOrMissing()).call(arg_0 -> ((ArchetypeService)this.service).save(arg_0)).onSuccess(() -> reminders.addSaved(reminder)).onFailure(status -> this.updateFailed(reminder, Messages.format((String)"reporting.reminder.sentnotupdated", (Object[])new Object[]{status.getMessage()}))).run();
                result = true;
            }
        }
        return result;
    }

    protected Party getLocation(Party customer) {
        Party location = (Party)this.service.getBean((IMObject)customer).getTarget("practice", Party.class);
        if (location == null) {
            location = this.config.getLocation();
        }
        return location;
    }

    protected Party getPractice() {
        return this.practice;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected CommunicationLogger getLogger() {
        return this.logger;
    }

    protected ReminderConfiguration getConfig() {
        return this.config;
    }

    protected void populate(PatientReminders reminders, Contact contact, Party location) {
        for (ReminderEvent reminder : reminders.getReminders()) {
            this.populate(reminder, contact, location);
        }
    }

    protected void populate(ReminderEvent event, Contact contact, Party location) {
        Act reminder = event.getReminder();
        Act item = event.getItem();
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        IMObjectBean itemBean = this.service.getBean((IMObject)item);
        Reference reminderTypeRef = bean.getTargetRef("reminderType");
        ReminderType reminderType = this.reminderTypes.get(reminderTypeRef);
        event.setContact(contact);
        event.setReminderType(reminderType != null ? reminderType.getEntity() : null);
        event.setProduct((Product)bean.getTarget("product", Product.class));
        event.setClinician((User)bean.getTarget("clinician", User.class));
        event.setReminderCount(itemBean.getInt("count"));
        event.setLocation(location);
    }

    protected Context createContext(ReminderEvent reminder, Party location) {
        LocalContext context = new LocalContext();
        context.setPatient(reminder.getPatient());
        context.setCustomer(reminder.getCustomer());
        context.setLocation(location);
        context.setPractice(this.practice);
        return context;
    }

    protected Contact getContact(Party customer, ContactMatcher matcher, Contact defaultContact) {
        Contact contact = defaultContact != null && matcher.isA(defaultContact) ? defaultContact : Contacts.find((Collection)Contacts.sort((Collection)customer.getContacts()), (ContactMatcher)matcher);
        return contact;
    }

    protected ContactMatcher createContactMatcher(String shortName) {
        return new PurposeMatcher(shortName, CONTACT_PURPOSE, false, (IMObjectBeanFactory)this.service);
    }

    protected ReminderType getReminderType(ReminderEvent reminder) {
        return this.reminderTypes.get(reminder.getReminderType());
    }

    protected String getNote(ReminderEvent reminder) {
        int reminderCount = reminder.getReminderCount();
        Entity reminderType = reminder.getReminderType();
        return this.getNote(reminderCount, reminderType);
    }

    protected String getNote(int reminderCount, Entity reminderType) {
        String name = reminderType != null ? reminderType.getName() : null;
        return Messages.format((String)"reminder.log.note", (Object[])new Object[]{name, reminderCount});
    }

    protected void complete(ReminderEvent event, PatientReminders state) {
        Act item = this.completeItem(event);
        Act reminder = event.getReminder();
        this.updateReminder(reminder, item);
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        bean.setValue("lastSent", (Object)new Date());
        state.addUpdated(event, reminder, item);
    }

    protected Act completeItem(ReminderEvent event) {
        return this.updateItem(event, "COMPLETED", null);
    }

    protected Act updateReminder(ReminderEvent event, Act item) {
        Act reminder = event.getReminder();
        if (this.updateReminder(reminder, item)) {
            return reminder;
        }
        return null;
    }

    protected Act updateItem(ReminderEvent event, String status, String message) {
        Act item = event.getItem();
        this.updateItem(item, status, message);
        return item;
    }

    protected void updateItem(Act item, String status, String message) {
        item.setStatus(status);
        IMObjectBean bean = this.service.getBean((IMObject)item);
        bean.setValue("processed", (Object)new Date());
        if (message != null) {
            int maxLength = bean.getMaxLength("error");
            message = StringUtils.abbreviate((String)message, (int)maxLength);
        }
        bean.setValue("error", (Object)message);
    }

    protected void error(ReminderEvent reminder, String message, T reminders) {
        Act item = this.updateItem(reminder, "ERROR", message);
        ((PatientReminders)reminders).addUpdated(reminder, item);
        ((PatientReminders)reminders).addError(reminder);
    }

    protected void error(T reminders, Throwable exception) {
        String message = ErrorFormatter.format((Throwable)exception);
        for (ReminderEvent event : ((PatientReminders)reminders).getReminders()) {
            this.error(event, message, reminders);
        }
    }

    protected void error(T reminders, String message) {
        for (ReminderEvent event : ((PatientReminders)reminders).getReminders()) {
            this.error(event, message, reminders);
        }
    }

    private void updateFailed(ReminderEvent reminder, String error) {
        this.actionFactory.newAction().backgroundOnly().withLatest((IMObject)reminder.getItem()).call(item -> {
            if (!"CANCELLED".equals(item.getStatus()) && !"ERROR".equals(item.getStatus())) {
                this.updateItem((Act)item, "ERROR", error);
                this.service.save((IMObject)item);
            }
        }).onFailure(status -> log.error("Failed to update reminder item={} with error={}: {}", new Object[]{reminder.getItem().getObjectReference(), error, status.getReason()})).run();
    }

    private boolean isReminderTypeInactive(ReminderEvent event) {
        IMObjectBean bean = this.service.getBean((IMObject)event.getReminder());
        Reference reminderTypeRef = bean.getTargetRef("reminderType");
        ReminderType reminderType = this.reminderTypes.get(reminderTypeRef);
        return reminderType != null && !reminderType.isActive();
    }

    private boolean updateReminder(Act reminder, Act item) {
        return this.reminderRules.updateReminder(reminder, item);
    }
}

