/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.im.report.Reporter;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.workspace.reporting.ReportingException;
import org.openvpms.web.workspace.reporting.reminder.GroupedReminders;

public class EmailReminders
extends GroupedReminders {
    private final EmailTemplateEvaluator evaluator;
    private final ReporterFactory factory;
    private EmailTemplate emailTemplate;

    public EmailReminders(ReminderType.GroupBy groupBy, boolean resend, EmailTemplateEvaluator evaluator, ReporterFactory factory) {
        super(groupBy, resend);
        this.evaluator = evaluator;
        this.factory = factory;
    }

    public String getEmailAddress() {
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)this.getContact());
        return bean.getString("emailAddress");
    }

    public String getSubject(Context context) {
        List<ReminderEvent> reminders = this.getReminders();
        Act reminder = reminders.get(0).getReminder();
        String subject = this.evaluator.getSubject(this.emailTemplate, (Object)reminder, context);
        if (StringUtils.isEmpty((CharSequence)subject)) {
            subject = this.getTemplate().getName();
        }
        return subject;
    }

    public String getMessage(Context context) {
        List<ObjectSet> sets;
        Act reminder;
        Reporter reporter;
        String body = null;
        List<ReminderEvent> reminders = this.getReminders();
        if (reminders.size() == 1 ? (reporter = this.evaluator.getMessageReporter(this.emailTemplate, (Object)(reminder = reminders.get(0).getReminder()), context)) != null && StringUtils.isEmpty((CharSequence)(body = this.evaluator.getMessage(reporter))) : (reporter = this.evaluator.getMessageReporter(this.emailTemplate, sets = this.getObjectSets(reminders), context)) != null && StringUtils.isEmpty((CharSequence)(body = this.evaluator.getMessage(reporter)))) {
            throw new ReportingException(ReportingException.ErrorCode.TemplateMissingEmailText, this.getTemplate().getName());
        }
        if (body == null) {
            body = this.evaluator.getMessage(this.emailTemplate, (Object)reminders.get(0).getReminder(), context);
        }
        if (StringUtils.isEmpty(body)) {
            throw new ReportingException(ReportingException.ErrorCode.TemplateMissingEmailText, this.getTemplate().getName());
        }
        return body;
    }

    public void setEmailTemplate(EmailTemplate template) {
        this.emailTemplate = template;
    }

    public EmailTemplate getEmailTemplate() {
        return this.emailTemplate;
    }

    public Document createAttachment(Context context) {
        Document result;
        List<ReminderEvent> reminders = this.getReminders();
        DocumentTemplate template = this.getTemplate();
        if (reminders.size() > 1) {
            result = this.getDocument((Reporter<?>)this.factory.createObjectSetReporter(this.getObjectSets(reminders), template), context);
        } else {
            ArrayList<Act> acts = new ArrayList<Act>();
            for (ReminderEvent event : reminders) {
                acts.add(event.getReminder());
            }
            result = this.getDocument((Reporter<?>)this.factory.createIMObjectReporter(acts, template), context);
        }
        return result;
    }

    private Document getDocument(Reporter<?> reporter, Context context) {
        reporter.setFields(ReportContextFactory.create((Context)context));
        return reporter.getDocument("application/pdf", true);
    }
}

