/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.insurance;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.clinician.ClinicianSelectField;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.location.LocationSelectField;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.reporting.insurance.ClaimResultSet;

public class ClaimQuery
extends DateRangeActQuery<Act> {
    public static final String[] ARCHETYPES = new String[]{"act.patientInsuranceClaim"};
    public static final String INCOMPLETE = "INCOMPLETE";
    public static final String NOT_SUBMITTED = "NOT_SUBMITTED";
    private final LocationSelectField locationSelector;
    private final IMObjectSelector insurerSelector;
    private final SelectField clinicianSelector;
    private final LookupField gapStatusSelector;
    private static final org.openvpms.component.model.lookup.Lookup INCOMPLETE_STATUS = new Lookup(new ArchetypeId("lookup.local"), "INCOMPLETE", Messages.get((String)"insurance.status.incomplete"));
    private static final org.openvpms.component.model.lookup.Lookup NOT_SUBMITTED_STATUS = new Lookup(new ArchetypeId("lookup.local"), "NOT_SUBMITTED", Messages.get((String)"insurance.status.notsubmitted"));
    private static final ActStatuses STATUSES = new ActStatuses((LookupQuery)new StatusLookupQuery());
    private static final ActStatuses GAP_STATUSES = new ActStatuses((LookupQuery)new NodeLookupQuery("act.patientInsuranceClaim", "status2"));

    public ClaimQuery(LayoutContext context) {
        super(null, null, null, ARCHETYPES, STATUSES, Act.class);
        this.setDefaultSortConstraint(DESCENDING_START_TIME);
        this.setAuto(true);
        this.locationSelector = this.createLocationSelector(context.getContext());
        this.clinicianSelector = this.createClinicianSelector();
        this.insurerSelector = new IMObjectSelector(DescriptorHelper.getDisplayName((String)"act.patientInsurancePolicy", (String)"insurer", (ArchetypeService)this.getService()), context, new String[]{"party.supplierInsurer"});
        this.gapStatusSelector = LookupFieldFactory.create((LookupQuery)GAP_STATUSES, (boolean)true);
    }

    public Party getLocation() {
        return (Party)this.locationSelector.getSelectedItem();
    }

    public String getStatus() {
        LookupField statusSelector = this.getStatusSelector();
        return statusSelector != null ? statusSelector.getSelectedCode() : null;
    }

    public String getGapStatus() {
        return this.gapStatusSelector.getSelectedCode();
    }

    public void setClinician(User clinician) {
        this.clinicianSelector.setSelectedItem((Object)clinician);
    }

    public void setGapStatus(String status) {
        this.gapStatusSelector.setSelected(status);
    }

    public Extent getHeight() {
        return this.getHeight(3);
    }

    public Party getInsurer() {
        return (Party)this.insurerSelector.getObject();
    }

    public User getClinician() {
        return (User)this.clinicianSelector.getSelectedItem();
    }

    protected Component createContainer() {
        return GridFactory.create((int)6);
    }

    protected void doLayout(Component container) {
        this.addSearchField(container);
        this.addStatusSelector(container);
        this.addInsurer(container);
        this.addDateRange(container);
        this.addGapStatusSelector(container);
        this.addLocation(container);
        this.addClinician(container);
    }

    protected void addSearchField(Component container) {
        Label label = LabelFactory.create();
        label.setText(DescriptorHelper.getDisplayName((String)"act.patientInsuranceClaim", (String)"id", (ArchetypeService)this.getService()));
        container.add((Component)label);
        TextField field = this.getSearchField();
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    protected void addGapStatusSelector(Component container) {
        Label label = LabelFactory.create();
        label.setText(DescriptorHelper.getDisplayName((String)"act.patientInsuranceClaim", (String)"status2", (ArchetypeService)this.getService()));
        container.add((Component)label);
        container.add((Component)this.gapStatusSelector);
        this.getFocusGroup().add((Component)this.gapStatusSelector);
    }

    protected ResultSet<Act> createResultSet(SortConstraint[] sort) {
        org.openvpms.component.model.lookup.Lookup selected = this.getStatusSelector().getSelected();
        String[] statuses = selected == INCOMPLETE_STATUS ? new String[]{"PENDING", "POSTED", "SUBMITTED", "ACCEPTED", "PRE_SETTLED", "CANCELLING"} : (selected == NOT_SUBMITTED_STATUS ? new String[]{"PENDING", "POSTED"} : super.getStatuses());
        Party location = this.getLocation();
        User clinician = (User)this.clinicianSelector.getSelectedItem();
        Party insurer = (Party)this.insurerSelector.getObject();
        String gapStatus = this.gapStatusSelector.getSelectedCode();
        return new ClaimResultSet(this.getArchetypeConstraint(), this.getValue(), location, insurer, clinician, this.getFrom(), this.getTo(), statuses, gapStatus, this.getMaxResults(), sort);
    }

    private void addClinician(Component container) {
        Label label = LabelFactory.create();
        label.setText(Messages.get((String)"label.clinician"));
        container.add((Component)label);
        container.add((Component)this.clinicianSelector);
        this.getFocusGroup().add((Component)this.clinicianSelector);
    }

    private void addLocation(Component container) {
        Label label = LabelFactory.create();
        label.setText(DescriptorHelper.getDisplayName((String)"act.patientInsuranceClaim", (String)"location", (ArchetypeService)this.getService()));
        container.add((Component)label);
        container.add((Component)this.locationSelector);
        this.getFocusGroup().add((Component)this.locationSelector);
    }

    private void addInsurer(Component container) {
        Label label = LabelFactory.create();
        label.setText(this.insurerSelector.getType());
        container.add((Component)label);
        Component component = this.insurerSelector.getComponent();
        container.add(component);
        this.getFocusGroup().add(component);
    }

    private LocationSelectField createLocationSelector(Context context) {
        LocationSelectField result = new LocationSelectField(context.getUser(), context.getPractice(), true);
        result.setSelectedItem((Object)context.getLocation());
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ClaimQuery.this.onQuery();
            }
        });
        return result;
    }

    private SelectField createClinicianSelector() {
        ClinicianSelectField result = new ClinicianSelectField();
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ClaimQuery.this.onQuery();
            }
        });
        return result;
    }

    private static class StatusLookupQuery
    extends NodeLookupQuery {
        StatusLookupQuery() {
            super("act.patientInsuranceClaim", "status");
        }

        public org.openvpms.component.model.lookup.Lookup getDefault() {
            return INCOMPLETE_STATUS;
        }

        public List<org.openvpms.component.model.lookup.Lookup> getLookups() {
            List lookups = super.getLookups();
            lookups.add(0, INCOMPLETE_STATUS);
            lookups.add(1, NOT_SUBMITTED_STATUS);
            return lookups;
        }
    }
}

