/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.email;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.party.PurposeMatcher;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.mail.EmailAddress;
import org.openvpms.web.workspace.reporting.ReportingException;

public class PracticeEmailAddresses {
    private final ArchetypeService service;
    private final Map<Reference, Contact> contacts = new HashMap<Reference, Contact>();
    private final Map<Reference, EmailAddress> addresses = new HashMap<Reference, EmailAddress>();
    private final Contact defaultContact;
    private final EmailAddress defaultAddress;

    public PracticeEmailAddresses(Party practice, List<Party> locations, String purpose, ArchetypeService service) {
        this.service = service;
        String defaultEmailName = ContactHelper.getDefaultEmailName((ArchetypeService)service);
        this.defaultContact = this.getPracticeEmailContact(practice, purpose);
        this.defaultAddress = this.getPracticeEmailAddress(this.defaultContact, practice, defaultEmailName);
        this.addLocations(purpose, defaultEmailName, locations);
    }

    public EmailAddress getPracticeAddress(Party customer) {
        IMObjectBean bean = this.service.getBean((IMObject)customer);
        Reference locationRef = bean.getTargetRef("practice");
        EmailAddress result = this.addresses.get(locationRef);
        if (result == null) {
            result = this.defaultAddress;
        }
        return result;
    }

    public EmailAddress getAddress(Party location) {
        return location.isA("party.organisationLocation") ? this.addresses.get(location.getObjectReference()) : this.defaultAddress;
    }

    public Contact getContact(Party location) {
        return location.isA("party.organisationLocation") ? this.contacts.get(location.getObjectReference()) : this.defaultContact;
    }

    public EmailAddress getPracticeAddress() {
        return this.defaultAddress;
    }

    private void addLocations(String purpose, String defaultEmailName, List<Party> locations) {
        for (Party location : locations) {
            EmailAddress address;
            PurposeMatcher matcher = new PurposeMatcher("contact.email", purpose, true, (IMObjectBeanFactory)this.service);
            Contact contact = Contacts.find((Collection)location.getContacts(), (ContactMatcher)matcher);
            if (contact == null || (address = this.getEmailAddress(contact, location, defaultEmailName)) == null) continue;
            Reference reference = location.getObjectReference();
            this.contacts.put(reference, contact);
            this.addresses.put(reference, address);
        }
    }

    private Contact getPracticeEmailContact(Party practice, String purpose) {
        PurposeMatcher matcher = new PurposeMatcher("contact.email", purpose, false, (IMObjectBeanFactory)this.service);
        Contact contact = Contacts.find((Collection)practice.getContacts(), (ContactMatcher)matcher);
        if (contact == null) {
            throw new ReportingException(ReportingException.ErrorCode.NoEmailContact, practice.getName());
        }
        return contact;
    }

    private EmailAddress getPracticeEmailAddress(Contact contact, Party practice, String defaultEmailName) {
        EmailAddress result = this.getEmailAddress(contact, practice, defaultEmailName);
        if (result == null) {
            throw new ReportingException(ReportingException.ErrorCode.InvalidEmailAddress, practice.getName());
        }
        return result;
    }

    private EmailAddress getEmailAddress(Contact contact, Party practice, String defaultEmailName) {
        IMObjectBean bean = this.service.getBean((IMObject)contact);
        String address = bean.getString("emailAddress");
        if (!StringUtils.isEmpty((CharSequence)address)) {
            String name = !StringUtils.isEmpty((CharSequence)contact.getName()) && !StringUtils.equals((CharSequence)defaultEmailName, (CharSequence)contact.getName()) ? contact.getName() : practice.getName();
            return new EmailAddress(address, name);
        }
        return null;
    }
}

