/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.email;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.rules.practice.MailServer;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.mail.EmailAddress;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.Mailer;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.component.service.DefaultMailService;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.reporting.ReportingException;
import org.openvpms.web.workspace.reporting.email.PracticeEmailAddresses;
import org.springframework.mail.javamail.JavaMailSender;

public class LocationMailerFactory {
    private final Party practice;
    private final ArchetypeService service;
    private final MailerFactory factory;
    private final String contactPurpose;
    private final MailPasswordResolver passwordResolver;
    private final PracticeEmailAddresses addresses;
    private final Map<Party, Long> settingsByLocation = new HashMap<Party, Long>();
    private final Map<Long, MailServer> settingsById = new HashMap<Long, MailServer>();
    private final Map<Long, JavaMailSender> senders = new HashMap<Long, JavaMailSender>();
    private static final Log log = LogFactory.getLog(LocationMailerFactory.class);

    public LocationMailerFactory(Party practice, PracticeRules practiceRules, ArchetypeService service, MailerFactory factory, String contactPurpose, MailPasswordResolver passwordResolver) {
        this.practice = practice;
        this.service = service;
        this.factory = factory;
        this.contactPurpose = contactPurpose;
        this.passwordResolver = passwordResolver;
        List locations = practiceRules.getLocations(practice);
        this.addresses = new PracticeEmailAddresses(practice, locations, contactPurpose, service);
        if (this.addMailSettings(practice) == null) {
            throw new ReportingException(ReportingException.ErrorCode.NoMailServer, practice.getName());
        }
        for (Party location : locations) {
            this.addMailSettings(location);
        }
    }

    public Mailer create(Party location, Context context) {
        MailServer settings = this.getMailSettings(location);
        EmailAddress from = this.addresses.getAddress(location);
        if (from == null || settings == null) {
            from = this.addresses.getPracticeAddress();
            settings = this.getMailSettings(this.practice);
        }
        Mailer mailer = this.create(context, settings);
        mailer.setFrom(from.toString(true));
        return mailer;
    }

    protected Mailer create(Context context, MailServer settings) {
        JavaMailSender sender = this.getMailSender(settings);
        return this.factory.create((MailContext)new CustomerMailContext(context), sender);
    }

    protected JavaMailSender getMailSender(MailServer settings) {
        Long id = settings.getId();
        JavaMailSender result = this.senders.get(id);
        if (result == null) {
            result = new DefaultMailService(settings, this.passwordResolver);
            this.senders.put(id, result);
        }
        return result;
    }

    protected MailServer addMailSettings(Party location) {
        MailServer settings = null;
        Reference reference = this.service.getBean((IMObject)location).getTargetRef("mailServer");
        if (reference != null) {
            if (this.addresses.getAddress(location) != null) {
                Entity entity;
                settings = this.settingsById.get(reference.getId());
                if (settings == null && (entity = (Entity)this.service.get(reference, true)) != null) {
                    settings = new MailServer(entity, this.service);
                    this.settingsById.put(entity.getId(), settings);
                }
                if (settings != null) {
                    this.settingsByLocation.put(location, settings.getId());
                }
            } else {
                log.info((Object)("Not using mail server for location=" + location.getName() + ": location has no " + this.contactPurpose + " email contact"));
            }
        }
        return settings;
    }

    private MailServer getMailSettings(Party location) {
        MailServer result = null;
        Long id = this.settingsByLocation.get(location);
        if (id != null) {
            result = this.settingsById.get(id);
        }
        return result;
    }
}

