/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.stock;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import org.openvpms.archetype.rules.stock.io.StockData;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.table.PagedIMTableModel;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.product.stock.StockDataTableModel;

public class StockImportErrorDialog
extends PopupDialog {
    public StockImportErrorDialog(List<StockData> errors, HelpContext help) {
        super(Messages.get((String)"product.stock.import.error.title"), "BrowserDialog", OK, help);
        this.setModal(true);
        ListResultSet resultSet = new ListResultSet(errors, 20);
        PagedIMTableModel model = new PagedIMTableModel((IMTableModel)new ErrorTableModel());
        PagedIMTable table = new PagedIMTable((IMTableModel)model, (ResultSet)resultSet);
        Label message = LabelFactory.create((String)"product.stock.import.error.message");
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, table.getComponent()})}));
    }

    private static class ErrorTableModel
    extends StockDataTableModel {
        private static final int LOCATION_ID = 4;
        private static final int LOCATION_NAME = 5;
        private static final int NEW_QUANTITY = 6;
        private static final int LINE = 7;
        private static final int ERROR = 8;

        public ErrorTableModel() {
            DefaultTableColumnModel model = (DefaultTableColumnModel)this.getColumnModel();
            model.addColumn(ErrorTableModel.createTableColumn((int)4, (String)"product.stock.import.locationId"));
            model.moveColumn(this.getColumnCount() - 1, 0);
            model.addColumn(ErrorTableModel.createTableColumn((int)5, (String)"product.stockLocation"));
            model.moveColumn(this.getColumnCount() - 1, 1);
            model.addColumn(ErrorTableModel.createTableColumn((int)6, (String)"product.stock.import.newQuantity"));
            model.addColumn(ErrorTableModel.createTableColumn((int)7, (String)"product.import.line"));
            model.addColumn(ErrorTableModel.createTableColumn((int)8, (String)"product.import.error"));
        }

        @Override
        protected Object getValue(StockData object, TableColumn column, int row) {
            Object result;
            switch (column.getModelIndex()) {
                case 4: {
                    result = object.getStockLocationId();
                    break;
                }
                case 5: {
                    result = object.getStockLocationName();
                    break;
                }
                case 6: {
                    result = object.getNewQuantity();
                    break;
                }
                case 7: {
                    result = object.getLine();
                    break;
                }
                case 8: {
                    result = object.getError();
                    break;
                }
                default: {
                    result = super.getValue(object, column, row);
                }
            }
            return result;
        }

        @Override
        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }
    }
}

