/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.io;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.TableColumn;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.ProductCSVWriter;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.DefaultIMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTableModel;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.servlet.DownloadServlet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.product.io.ProductExportQuery;
import org.openvpms.web.workspace.product.io.ProductImportExportTableModel;
import org.openvpms.web.workspace.product.io.ProductPrices;

public class ProductExportDialog
extends BrowserDialog<Product> {
    private final ProductPriceRules rules;
    private final TaxRules taxRules;
    private static final String EXPORT_ID = "button.export";
    private static final String[] BUTTONS = new String[]{"button.export", "close"};

    public ProductExportDialog(LayoutContext context, HelpContext help) {
        super(Messages.get((String)"product.export.title"), BUTTONS, false, help);
        this.setStyleName("ProductImportExportDialog");
        this.rules = (ProductPriceRules)ServiceHelper.getBean(ProductPriceRules.class);
        this.taxRules = new TaxRules(context.getContext().getPractice(), (ArchetypeService)ServiceHelper.getArchetypeService());
        ProductExportQuery query = new ProductExportQuery(context.getContext());
        PagedProductPricesTableModel model = new PagedProductPricesTableModel();
        DefaultIMObjectTableBrowser browser = new DefaultIMObjectTableBrowser((Query)query, (IMTableModel)model, context);
        this.init((Browser)browser, null);
        this.setCloseOnSelection(false);
    }

    protected void onButton(String button) {
        if (EXPORT_ID.equals(button)) {
            try {
                this.onExport();
            }
            catch (Throwable exception) {
                ErrorHandler.getInstance().error(exception);
            }
        } else {
            super.onButton(button);
        }
    }

    private void onExport() {
        Document document;
        ProductExportQuery query = this.getQuery();
        ProductCSVWriter exporter = new ProductCSVWriter((IArchetypeService)ServiceHelper.getArchetypeService(), this.rules, this.taxRules, (DocumentHandlers)ServiceHelper.getBean(DocumentHandlers.class));
        ResultSetIterator iterator = new ResultSetIterator(query.query());
        boolean includeLinkedPrices = query.includeLinkedPrices();
        PricingGroup pricingGroup = query.getPricingGroup();
        switch (query.getPrices()) {
            case CURRENT: {
                document = exporter.write((Iterator)iterator, true, includeLinkedPrices, pricingGroup);
                break;
            }
            case ALL: {
                document = exporter.write((Iterator)iterator, false, includeLinkedPrices, pricingGroup);
                break;
            }
            default: {
                document = exporter.write((Iterator)iterator, query.getFrom(), query.getTo(), includeLinkedPrices, pricingGroup);
            }
        }
        DownloadServlet.startDownload((org.openvpms.component.model.document.Document)document);
    }

    private ProductExportQuery getQuery() {
        return (ProductExportQuery)((QueryBrowser)this.getBrowser()).getQuery();
    }

    private class ProductPricesModel
    extends ProductImportExportTableModel<ProductPrices> {
        private ProductPricesModel() {
        }

        protected Object getValue(ProductPrices object, TableColumn column, int row) {
            Object result;
            boolean first = row == 0 || ((ProductPrices)this.getObjects().get(row - 1)).getProduct().getId() != object.getProduct().getId();
            ProductPrice fixedPrice = object.getFixedPrice();
            ProductPrice unitPrice = object.getUnitPrice();
            switch (column.getModelIndex()) {
                case 0: {
                    result = first ? Long.valueOf(object.getProduct().getId()) : null;
                    break;
                }
                case 1: {
                    result = first ? object.getProduct().getName() : null;
                    break;
                }
                case 2: {
                    if (first) {
                        IMObjectBean bean = IMObjectHelper.getBean((IMObject)object.getProduct());
                        result = bean.getString("printedName");
                        break;
                    }
                    result = null;
                    break;
                }
                case 3: {
                    result = fixedPrice != null ? this.rightAlign(fixedPrice.getPrice()) : null;
                    break;
                }
                case 4: {
                    result = this.getCost(fixedPrice);
                    break;
                }
                case 5: {
                    result = this.getMaxDiscount(fixedPrice);
                    break;
                }
                case 6: {
                    result = fixedPrice != null ? this.rightAlign(fixedPrice.getFromDate()) : null;
                    break;
                }
                case 7: {
                    result = fixedPrice != null ? this.rightAlign(fixedPrice.getToDate()) : null;
                    break;
                }
                case 8: {
                    result = this.getPricingGroups(fixedPrice);
                    break;
                }
                case 9: {
                    result = unitPrice != null ? this.rightAlign(unitPrice.getPrice()) : null;
                    break;
                }
                case 10: {
                    result = this.getCost(unitPrice);
                    break;
                }
                case 11: {
                    result = this.getMaxDiscount(unitPrice);
                    break;
                }
                case 12: {
                    result = unitPrice != null ? this.rightAlign(unitPrice.getFromDate()) : null;
                    break;
                }
                case 13: {
                    result = unitPrice != null ? this.rightAlign(unitPrice.getToDate()) : null;
                    break;
                }
                case 14: {
                    result = this.getPricingGroups(unitPrice);
                    break;
                }
                default: {
                    result = null;
                }
            }
            if (result != null && !(result instanceof Component)) {
                Label label = LabelFactory.create();
                TableLayoutData layoutData = new TableLayoutData();
                layoutData.setAlignment(Alignment.ALIGN_TOP);
                label.setLayoutData((LayoutData)layoutData);
                label.setText(result.toString());
                result = label;
            }
            return result;
        }

        private Object getPricingGroups(ProductPrice price) {
            List groups;
            Column result = null;
            if (price != null && !(groups = ProductExportDialog.this.rules.getPricingGroups(price)).isEmpty()) {
                result = this.getPricingGroups(groups, "default");
            }
            return result;
        }

        private Label getCost(ProductPrice price) {
            return this.rightAlign(price, "cost");
        }

        private Label getMaxDiscount(ProductPrice price) {
            return this.rightAlign(price, "maxDiscount");
        }

        private Label rightAlign(ProductPrice price, String name) {
            Label result = null;
            if (price != null) {
                IMObjectBean bean = this.getBean((IMObject)price);
                result = this.rightAlign(bean.getBigDecimal(name));
            }
            return result;
        }
    }

    private final class PagedProductPricesTableModel
    extends PagedIMTableModel<Product, ProductPrices> {
        public PagedProductPricesTableModel() {
            super((IMTableModel)new ProductPricesModel());
        }

        protected List<ProductPrices> convertTo(List<Product> list) {
            ArrayList<ProductPrices> result = new ArrayList<ProductPrices>();
            boolean includeLinkedPrices = ProductExportDialog.this.getQuery().includeLinkedPrices();
            PricingGroup pricingGroup = ProductExportDialog.this.getQuery().getPricingGroup();
            for (Product product : list) {
                List<ProductPrice> fixedPrices = this.getPrices(product, "productPrice.fixedPrice", includeLinkedPrices, pricingGroup);
                List<ProductPrice> unitPrices = this.getPrices(product, "productPrice.unitPrice", includeLinkedPrices, pricingGroup);
                int count = Math.max(fixedPrices.size(), unitPrices.size());
                if (count == 0) {
                    count = 1;
                }
                for (int i = 0; i < count; ++i) {
                    ProductPrice fixedPrice = i < fixedPrices.size() ? fixedPrices.get(i) : null;
                    ProductPrice unitPrice = i < unitPrices.size() ? unitPrices.get(i) : null;
                    ProductPrices prices = new ProductPrices(product, fixedPrice, unitPrice);
                    result.add(prices);
                }
            }
            return result;
        }

        private List<ProductPrice> getPrices(Product product, String shortName, boolean includeLinkedPrices, PricingGroup pricingGroup) {
            ArrayList<ProductPrice> result = new ArrayList<ProductPrice>();
            ProductExportQuery query = ProductExportDialog.this.getQuery();
            ProductExportQuery.Prices prices = query.getPrices();
            if (prices == ProductExportQuery.Prices.CURRENT) {
                Date now = new Date();
                if (pricingGroup.isAll()) {
                    result.addAll(ProductExportDialog.this.rules.getProductPrices(product, shortName, now, includeLinkedPrices, pricingGroup));
                } else {
                    List list = ProductExportDialog.this.rules.getProductPrices(product, shortName, now, includeLinkedPrices, pricingGroup);
                    if (!list.isEmpty()) {
                        result.add((ProductPrice)list.get(0));
                    }
                }
            } else if (prices == ProductExportQuery.Prices.ALL) {
                result.addAll(ProductExportDialog.this.rules.getProductPrices(product, shortName, includeLinkedPrices, pricingGroup));
            } else {
                result.addAll(ProductExportDialog.this.rules.getProductPrices(product, shortName, query.getFrom(), query.getTo(), includeLinkedPrices, pricingGroup));
            }
            return result;
        }
    }
}

