/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product;

import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.product.ProductHelper;
import org.openvpms.web.component.im.product.ProductQuery;
import org.openvpms.web.system.ServiceHelper;

public class PricingGroupProductQuery
extends ProductQuery {
    private final boolean admin;
    private PricingGroupListener pricingGroupListener;

    public PricingGroupProductQuery(String[] shortNames, Context context) {
        super(shortNames, context);
        User user = context.getUser();
        UserRules rules = (UserRules)ServiceHelper.getBean(UserRules.class);
        this.admin = user != null ? rules.isAdministrator(user) || rules.canEdit(user, "product.*") : false;
    }

    public void setPricingGroupListener(PricingGroupListener listener) {
        this.pricingGroupListener = listener;
    }

    protected void doLayout(Component container) {
        super.doLayout(container);
        if (this.admin && ProductHelper.pricingGroupsConfigured()) {
            this.addPricingGroupSelector(container, false);
        }
    }

    protected void onPricingGroupChanged(PricingGroup pricingGroup) {
        super.onPricingGroupChanged(pricingGroup);
        if (this.pricingGroupListener != null) {
            this.pricingGroupListener.onPricingGroupChanged();
        }
    }

    public static interface PricingGroupListener {
        public void onPricingGroupChanged();
    }
}

