/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.app.LocationMonitor;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.component.workspace.ResultSetCRUDWorkspace;
import org.openvpms.web.workspace.product.PricingGroupProductBrowser;
import org.openvpms.web.workspace.product.PricingGroupProductQuery;
import org.openvpms.web.workspace.product.ProductCRUDWindow;

public class InformationWorkspace
extends ResultSetCRUDWorkspace<Product> {
    private final LocationMonitor monitor;

    public InformationWorkspace(Context context) {
        super("product.information", context);
        this.setArchetypes(Product.class, new String[]{"product.*"});
        this.monitor = new LocationMonitor((GlobalContext)context, newLocation -> this.updateButtons());
    }

    public void setObject(Product object) {
        super.setObject((IMObject)object);
        this.getContext().setProduct(object);
    }

    public void show() {
        super.show();
        this.monitor.register();
        this.updateButtons();
    }

    public void hide() {
        this.monitor.unregister();
        super.hide();
    }

    protected Product getLatest() {
        return (Product)this.getLatest((IMObject)this.getContext().getProduct());
    }

    protected CRUDWindow<Product> createCRUDWindow() {
        QueryBrowser browser = this.getBrowser();
        return new ProductCRUDWindow((Archetypes<Product>)this.getArchetypes(), (Query<Product>)browser.getQuery(), (ResultSet<Product>)browser.getResultSet(), this.getContext(), this.getHelpContext());
    }

    protected Query<Product> createQuery() {
        return new PricingGroupProductQuery(this.getArchetypes().getShortNames(), this.getContext());
    }

    protected Browser<Product> createBrowser(Query<Product> query) {
        DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), this.getHelpContext());
        return new PricingGroupProductBrowser((PricingGroupProductQuery)query, (LayoutContext)context);
    }

    private void updateButtons() {
        ResultSetCRUDWindow window;
        if (this.monitor.changed() && (window = this.getCRUDWindow()) != null) {
            window.refreshButtons();
        }
    }
}

