/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.visit;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.estimate.EstimateInvoicer;
import org.openvpms.web.workspace.patient.charge.VisitChargeEditor;
import org.openvpms.web.workspace.patient.estimate.PatientEstimateCRUDWindow;
import org.openvpms.web.workspace.patient.visit.VisitChargeCRUDWindow;
import org.openvpms.web.workspace.patient.visit.VisitEditor;

public class VisitEstimateCRUDWindow
extends PatientEstimateCRUDWindow {
    private VisitEditor visitEditor;

    public VisitEstimateCRUDWindow(Context context, HelpContext help) {
        super(context, help);
    }

    public void setVisitEditor(VisitEditor editor) {
        this.visitEditor = editor;
    }

    protected Component doLayout() {
        return this.getContainer();
    }

    protected LayoutContext createViewLayoutContext() {
        LayoutContext context = super.createViewLayoutContext();
        context.setContextSwitchListener(null);
        return context;
    }

    @Override
    protected boolean canInvoice(Act act) {
        boolean result = super.canInvoice(act);
        if (result) {
            if (this.visitEditor == null || this.visitEditor.getChargeEditor() == null) {
                this.showStatusError(act, "patient.estimate.invoice.title", "patient.estimate.invoice.noinvoice");
                result = false;
            } else if (!this.getRules().isPatientEstimate(act, this.getContext().getPatient())) {
                this.showStatusError(act, "patient.estimate.invoice.title", "patient.estimate.invoice.toomanypets");
                result = false;
            }
        }
        return result;
    }

    @Override
    protected void invoice(Act estimate) {
        VisitChargeCRUDWindow window = this.visitEditor.getCharge();
        boolean autoChargeOrders = window.isAutoChargeOrders();
        window.setAutoChargeOrders(false);
        this.visitEditor.selectCharges();
        VisitChargeEditor editor = this.visitEditor.getChargeEditor();
        EstimateInvoicer invoicer = this.createEstimateInvoicer();
        invoicer.invoice(estimate, editor, (LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
        estimate.setStatus("INVOICED");
        SaveHelper.save((IMObject)estimate);
        this.onRefresh((IMObject)estimate);
        window.setAutoChargeOrders(autoChargeOrders);
    }
}

