/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.visit;

import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.openvpms.web.component.macro.MacroDialog;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.charge.DefaultEditorQueue;
import org.openvpms.web.workspace.customer.charge.UndispensedOrderChecker;
import org.openvpms.web.workspace.patient.charge.VisitChargeEditor;
import org.openvpms.web.workspace.patient.visit.VisitEditor;

public class VisitEditorDialog
extends PopupDialog {
    private final VisitEditor editor;

    public VisitEditorDialog(String title, VisitEditor visitEditor, HelpContext help) {
        super(title, "BrowserDialog", APPLY_OK_CANCEL, help);
        Property status;
        this.editor = visitEditor;
        this.setModal(true);
        this.getLayout().add(visitEditor.getComponent());
        VisitChargeEditor chargeEditor = this.editor.getChargeEditor();
        if (chargeEditor != null && (status = chargeEditor.getProperty("status")) != null) {
            this.onStatusChanged(status);
            status.addModifiableListener(modifiable -> this.onStatusChanged(status));
        }
        visitEditor.setListener(this::onSelected);
        ButtonSet buttons = this.getButtons();
        buttons.setHideDisabled(true);
        this.setHistoryButtons();
        buttons.addKeyListener(4173, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                VisitEditorDialog.this.onMacro();
            }
        });
        this.resize("VisitEditorDialog.size");
    }

    public VisitEditor getEditor() {
        return this.editor;
    }

    public HelpContext getHelpContext() {
        return this.editor.getHelpContext();
    }

    protected void onApply() {
        this.prepare(false);
    }

    protected void onOK() {
        this.prepare(true);
    }

    protected void onSelected(int index) {
        switch (index) {
            case 0: {
                this.onHistorySelected();
                break;
            }
            case 1: {
                this.onProblemsSelected();
                break;
            }
            case 2: {
                this.onInvoiceSelected();
                break;
            }
            case 3: {
                this.onRemindersSelected();
                break;
            }
            case 4: {
                this.onAlertsSelected();
                break;
            }
            case 5: {
                this.onDocumentsSelected();
                break;
            }
            case 6: {
                this.onPrescriptionSelected();
                break;
            }
            case 7: {
                this.onEstimatesSelected();
            }
        }
    }

    protected ButtonSet setDefaultButtons(boolean apply) {
        ButtonSet buttons = this.getButtons();
        buttons.removeAll();
        if (apply) {
            this.addButton("apply");
        }
        this.addButton("ok");
        this.addButton("cancel");
        return buttons;
    }

    protected void onNew() {
        this.editor.getCharge().create();
        this.onInvoiceSelected();
    }

    private void prepare(boolean close) {
        VisitChargeEditor chargeEditor = this.editor.getChargeEditor();
        if (chargeEditor != null) {
            UndispensedOrderChecker checker = new UndispensedOrderChecker(chargeEditor);
            checker.confirm(this.getHelpContext(), () -> this.saveCharge(close));
        } else if (close) {
            super.onOK();
        }
    }

    private void saveCharge(boolean close) {
        if (this.editor.save()) {
            this.processDocuments(close);
        }
    }

    private void onStatusChanged(Property status) {
        String value = (String)status.getValue();
        AbstractButton apply = this.getButtons().getButton("apply");
        if (apply != null) {
            apply.setEnabled(!"POSTED".equals(value));
        }
    }

    private void onHistorySelected() {
        this.setHistoryButtons();
    }

    private void onProblemsSelected() {
        ButtonSet buttons = this.setDefaultButtons(false);
        this.editor.setButtons(buttons);
    }

    private void onInvoiceSelected() {
        ButtonSet buttons = this.getButtons();
        buttons.removeAll();
        if (this.getEditor().getChargeEditor() != null) {
            this.addButton("apply");
        }
        this.addButton("ok");
        this.addButton("cancel");
        if (this.getEditor().getChargeEditor() == null) {
            buttons.add("button.new", this::onNew);
        }
        buttons.add("button.completed", this::onComplete);
        buttons.add("button.inprogress", this::onInProgress);
        buttons.add("button.invoiceOrders", this::invoiceOrders);
        buttons.add("button.submitInvestigations", this::submitInvestigations);
        this.editor.setButtons(buttons);
    }

    private void onComplete() {
        if (this.editor.saveAsCompleted()) {
            this.processDocuments(true);
        }
    }

    private void onInProgress() {
        if (this.editor.saveAsInProgress()) {
            this.processDocuments(true);
        }
    }

    private void invoiceOrders() {
        this.editor.getCharge().chargeOrders();
    }

    private void submitInvestigations() {
        this.editor.getCharge().submitInvestigations();
    }

    private void processDocuments(final boolean close) {
        VisitChargeEditor editor = this.editor.getChargeEditor();
        if (editor != null) {
            final MutableBoolean cancelled = new MutableBoolean(false);
            DefaultEditorQueue queue = new DefaultEditorQueue(false, this.getEditor().getContext()){

                @Override
                protected void completed() {
                    if (close && !cancelled.booleanValue()) {
                        VisitEditorDialog.super.onOK();
                    }
                }
            };
            editor.postSave(queue, close, cancelled);
            queue.start();
        }
    }

    private void onRemindersSelected() {
        this.editor.setButtons(this.setDefaultButtons(false));
    }

    private void onAlertsSelected() {
        this.editor.setButtons(this.setDefaultButtons(false));
    }

    private void onDocumentsSelected() {
        this.editor.setButtons(this.setDefaultButtons(false));
    }

    private void onPrescriptionSelected() {
        ButtonSet buttons = this.setDefaultButtons(false);
        this.editor.setButtons(buttons);
    }

    private void onEstimatesSelected() {
        ButtonSet buttons = this.setDefaultButtons(false);
        this.editor.setButtons(buttons);
    }

    private void setHistoryButtons() {
        ButtonSet buttons = this.setDefaultButtons(true);
        this.editor.setButtons(buttons);
    }

    private void onMacro() {
        if (this.editor.getSelectedTab() == 2 && this.editor.getChargeEditor() != null) {
            MacroDialog dialog = new MacroDialog(this.editor.getContext(), this.getHelpContext());
            dialog.show();
        }
    }
}

