/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.vetcheck;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.party.Address;
import org.openvpms.domain.party.Email;
import org.openvpms.domain.party.Phone;
import org.openvpms.domain.patient.Microchip;
import org.openvpms.domain.patient.Patient;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.vetcheck.VetCheckLink;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class VetCheckRules {
    private final DomainService domainService;
    private final MedicalRecordRules rules;
    private final IArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private final PracticeService practiceService;
    private final SingletonService singletonService;
    private static final String URL = "https://plugin.vetcheck.it";
    private static final String VETCHECK = "entity.linkProviderVetCheck";

    public VetCheckRules(DomainService domainService, MedicalRecordRules rules, IArchetypeService service, PlatformTransactionManager transactionManager, PracticeService practiceService, SingletonService singletonService) {
        this.domainService = domainService;
        this.rules = rules;
        this.service = service;
        this.transactionManager = transactionManager;
        this.practiceService = practiceService;
        this.singletonService = singletonService;
    }

    public boolean isVetCheckEnabled() {
        boolean result = false;
        Party practice = this.practiceService.getPractice();
        if (practice != null) {
            IMObjectBean bean = this.service.getBean((IMObject)practice);
            result = bean.getBoolean("enableVetCheck");
        }
        return result;
    }

    public String getURL() {
        return this.getURL(null);
    }

    public String getURL(Party patient) {
        Patient pet = null;
        Customer customer = null;
        if (patient != null) {
            pet = (Patient)this.domainService.create((IMObject)patient, Patient.class);
            customer = pet.getOwner();
        }
        return this.getURL(customer, pet);
    }

    public VetCheckLink addLink(Party patient, Party location, User clinician, String data) {
        VetCheckLink result = null;
        List parameters = URLEncodedUtils.parse((String)data, (Charset)StandardCharsets.UTF_8);
        String title = this.getValue("title", parameters);
        String url = this.getValue("share_link", parameters);
        if (url != null && title != null) {
            TransactionTemplate template = new TransactionTemplate(this.transactionManager);
            Act act = (Act)template.execute(transactionStatus -> {
                Act link = this.createLink(patient, clinician, url, title);
                Act event = this.rules.getEventForAddition(patient, new Date(), null, location);
                IMObjectBean bean = this.service.getBean((IMObject)event);
                bean.addTarget("items", (IMObject)link, "event");
                bean.save(new IMObject[]{link});
                return link;
            });
            result = new VetCheckLink(title, url, act);
        }
        return result;
    }

    public List<Act> getMostRecentLinks(Party patient, int count) {
        ArchetypeQuery query = new ArchetypeQuery("act.patientClinicalLink");
        JoinConstraint patientJoin = Constraints.join((String)"patient");
        patientJoin.add((IConstraint)Constraints.eq((String)"entity", (Object)patient));
        patientJoin.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.patientClinicalLink"));
        JoinConstraint providerJoin = Constraints.join((String)"provider");
        providerJoin.add((IConstraint)Constraints.join((String)"entity", (BaseArchetypeConstraint)new ShortNameConstraint(VETCHECK)));
        providerJoin.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.patientClinicalLink"));
        query.add((IConstraint)patientJoin);
        query.add((IConstraint)providerJoin);
        query.add((IConstraint)Constraints.sort((String)"startTime", (boolean)false));
        query.add((IConstraint)Constraints.sort((String)"id", (boolean)false));
        query.setMaxResults(count);
        return this.service.get((IArchetypeQuery)query).getResults();
    }

    private String getURL(Customer customer, Patient patient) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)URL);
        if (customer != null && patient != null) {
            Address address = customer.getAddress();
            Phone phone = customer.getPhone();
            Email email = customer.getEmail();
            Weight weight = patient.getWeight();
            String sex = "";
            sex = patient.isDesexed() ? patient.getSex() + " " + Messages.get((String)"patient.desexed") : patient.getSex() + " " + Messages.get((String)"patient.entire");
            Microchip microchip = patient.getMicrochip();
            builder.queryParam("client_first_name", new Object[]{customer.getFirstName()}).queryParam("client_last_name", new Object[]{customer.getLastName()}).queryParam("client_address", new Object[]{address != null ? address.format(true) : null}).queryParam("client_phone", new Object[]{phone != null ? phone.getPhoneNumber() : null}).queryParam("client_email_address", new Object[]{email != null ? email.getEmailAddress() : null}).queryParam("patient_id", new Object[]{patient.getId()}).queryParam("pet_name", new Object[]{patient.getName()}).queryParam("pet_species", new Object[]{patient.getSpeciesName()}).queryParam("pet_breed", new Object[]{patient.getBreedName()}).queryParam("pet_sex", new Object[]{sex}).queryParam("pet_dob", new Object[]{patient.getDateOfBirth()}).queryParam("pet_weight", new Object[]{!weight.isZero() ? weight : null}).queryParam("pet_color", new Object[]{patient.getColourName()}).queryParam("pet_microchip", new Object[]{microchip != null ? microchip.getIdentity() : null});
        }
        return builder.toUriString();
    }

    private Act createLink(Party patient, User clinician, String url, String description) {
        Act act = (Act)this.service.create("act.patientClinicalLink", Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("clinician", (IMObject)clinician);
        bean.setValue("url", (Object)url);
        bean.setValue("description", (Object)StringUtils.abbreviate((String)description, (int)bean.getMaxLength("description")));
        bean.setTarget("provider", (IMObject)this.getVetCheck());
        return act;
    }

    private Entity getVetCheck() {
        return (Entity)this.singletonService.get(VETCHECK, Entity.class, true);
    }

    private String getValue(String name, List<NameValuePair> parameters) {
        String result = null;
        for (NameValuePair parameter : parameters) {
            if (!name.equals(parameter.getName())) continue;
            result = parameter.getValue();
            break;
        }
        return result;
    }
}

