/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.summary;

import java.util.function.Consumer;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class PatientCageEditor {
    private static final String REMOVE_CAGE_ID = "button.removeCage";

    public void edit(final Party patient, Context context, HelpContext help, final Consumer<Party> completionListener) {
        final BrowserDialog<Lookup> dialog = this.createCageBrowserDialog(context, help);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                Lookup lookup = (Lookup)dialog.getSelected();
                PatientCageEditor.this.update(patient, lookup, completionListener);
            }

            public void onAction(String action) {
                if (PatientCageEditor.REMOVE_CAGE_ID.equals(action)) {
                    PatientCageEditor.this.update(patient, null, completionListener);
                }
            }
        });
        dialog.show();
    }

    private BrowserDialog<Lookup> createCageBrowserDialog(Context context, HelpContext help) {
        Query query = QueryFactory.create((String)"lookup.cage", (Context)context);
        Browser browser = BrowserFactory.create((Query)query, (LayoutContext)new DefaultLayoutContext(context, help));
        String displayName = DescriptorHelper.getDisplayName((String)"lookup.cage", (ArchetypeService)ServiceHelper.getArchetypeService());
        String title = Messages.format((String)"imobject.select.title", (Object[])new Object[]{displayName});
        String[] buttons = new String[]{"cancel", REMOVE_CAGE_ID};
        BrowserDialog dialog = new BrowserDialog(title, buttons, browser, help);
        dialog.resize("BrowserDialog.size.lookup.cage");
        return dialog;
    }

    private void update(Party patient, Lookup lookup, Consumer<Party> completionListener) {
        ((ActionFactory)ServiceHelper.getBean(ActionFactory.class)).newAction().withLatest((IMObject)patient).asBean(bean -> {
            bean.setValue("cage", (Object)(lookup != null ? lookup.getCode() : null));
            bean.save();
            completionListener.accept((Party)bean.getObject(Party.class));
        }).run();
    }
}

