/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.problem;

import echopointng.LabelEx;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryTableModel;

public class ProblemTableModel
extends AbstractPatientHistoryTableModel {
    public ProblemTableModel(LayoutContext context) {
        super("act.patientClinicalProblem", context, 100);
    }

    @Override
    protected Component getType(IMObjectBean bean) {
        if (bean.isA(new String[]{"act.patientClinicalEvent"})) {
            return this.getHyperlinkedType(bean);
        }
        return super.getType(bean);
    }

    @Override
    protected Component formatParent(IMObjectBean bean) {
        Label result;
        String presentingComplaint = LookupNameHelper.getName((IMObject)bean.getObject(), (String)"presentingComplaint");
        if (presentingComplaint != null) {
            String date = this.formatDateRange(bean);
            String title = this.formatProblemText(bean);
            Label dateLabel = LabelFactory.create(null, (String)"bold");
            Label titleLabel = LabelFactory.create(null, (String)"bold");
            Label complaintLabel = LabelFactory.create();
            dateLabel.setText(date);
            titleLabel.setText(title);
            complaintLabel.setText(Messages.format((String)"patient.record.summary.presentingComplaint", (Object[])new Object[]{presentingComplaint}));
            Row row1 = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{dateLabel, titleLabel});
            Row padding = RowFactory.create((String)"Inset", (Component[])new Component[]{new Label("")});
            Component spacer1 = this.getDateSpacer();
            LabelEx spacer2 = new LabelEx("");
            spacer2.setStyleName("MedicalRecordSummary.type");
            Row row2 = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{padding, spacer1, spacer2, complaintLabel});
            result = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{row1, row2});
        } else {
            String date = this.formatDateRange(bean);
            String text = this.formatProblemText(bean);
            Label summary = LabelFactory.create(null, (String)"bold");
            summary.setText(Messages.format((String)"patient.record.summary.datedTitle", (Object[])new Object[]{date, text}));
            result = summary;
        }
        return result;
    }

    protected String formatProblemText(IMObjectBean bean) {
        String reason = LookupNameHelper.getName((IMObject)bean.getObject(), (String)"reason");
        if (reason == null) {
            reason = Messages.get((String)"patient.record.summary.diagnosis.none");
        }
        return this.formatParentText(bean, reason);
    }

    @Override
    protected Component formatItem(IMObjectBean bean) {
        if (bean.isA(new String[]{"act.patientClinicalEvent"})) {
            return this.formatEvent(bean);
        }
        return super.formatItem(bean);
    }

    private Component formatEvent(IMObjectBean bean) {
        Label result;
        String text = this.formatEventText(bean);
        Label summary = LabelFactory.create();
        summary.setText(text);
        String detail = this.getText((Act)bean.getObject(Act.class), false);
        if (detail != null) {
            result = new Column();
            result.add((Component)summary);
            result.add((Component)this.getTextDetail(detail));
        } else {
            result = summary;
        }
        return result;
    }
}

