/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.problem;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import org.apache.commons.collections.ComparatorUtils;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.list.ShortNameListModel;
import org.openvpms.web.component.im.query.PageLocator;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.relationship.RelationshipHelper;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryQuery;

public class ProblemQuery
extends AbstractPatientHistoryQuery {
    private final IArchetypeService service = ServiceHelper.getArchetypeService();
    private static final String[] ARCHETYPES = new String[]{"act.patientClinicalProblem"};
    private static final SortConstraint[] SORT = new SortConstraint[]{new NodeSortConstraint("status", false), new NodeSortConstraint("startTime", false), new NodeSortConstraint("id")};

    public ProblemQuery(Party patient, Preferences preferences) {
        super(patient, ARCHETYPES, preferences);
        String[] archetypes = RelationshipHelper.getTargetShortNames((ArchetypeService)this.service, (String[])new String[]{"actRelationship.patientClinicalProblemItem"});
        this.setAvailableArchetypes(archetypes);
        this.setSelectedArchetypes(this.getAvailableArchetypes());
        this.setAuto(true);
        this.setDefaultSortConstraint(SORT);
    }

    public int getPage(Act problem) {
        int page = 0;
        IMObjectBean bean = this.service.getBean((IMObject)problem);
        Reference patient = bean.getTargetRef("patient");
        if (patient != null) {
            ArchetypeQuery query = new ArchetypeQuery(this.getShortNames(), false, false);
            query.add((IConstraint)new ParticipantConstraint("patient", "participation.patient", patient));
            PageLocator locator = new PageLocator((IMObject)problem, query, this.getMaxResults());
            locator.addKey("status", false, ComparatorUtils.naturalComparator());
            locator.addKey("startTime", false, PageLocator.DATE_COMPARATOR);
            page = locator.getPage();
        }
        return page;
    }

    protected void doLayout(Component container) {
        Label typeLabel = LabelFactory.create((String)"query.type");
        container.add((Component)typeLabel);
        SelectField shortNameSelector = this.getArchetypeSelector();
        container.add((Component)shortNameSelector);
        Button sort = this.getSort();
        container.add((Component)sort);
        this.addSearchField(container);
        FocusGroup focusGroup = this.getFocusGroup();
        focusGroup.add((Component)shortNameSelector);
        focusGroup.add((Component)sort);
        super.doLayout(container);
    }

    @Override
    protected void updateSelectedArchetypes(ShortNameListModel model, int selected) {
        if (model.isAll(selected)) {
            this.setSelectedArchetypes(this.getAvailableArchetypes());
        } else {
            String shortName = model.getShortName(selected);
            this.setSelectedArchetypes(this.getSelectedShortNames(shortName));
        }
    }

    private String[] getSelectedShortNames(String shortName) {
        if ("act.patientInvestigation".equals(shortName)) {
            return new String[]{shortName, "act.patientInvestigationVersion"};
        }
        if ("act.patientDocumentAttachment".equals(shortName)) {
            return new String[]{shortName, "act.patientDocumentAttachmentVersion"};
        }
        if ("act.patientDocumentImage".equals(shortName)) {
            return new String[]{shortName, "act.patientDocumentImageVersion"};
        }
        if ("act.patientDocumentLetter".equals(shortName)) {
            return new String[]{shortName, "act.patientDocumentLetterVersion"};
        }
        return new String[]{shortName};
    }
}

