/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.problem;

import java.util.List;
import nextapp.echo2.app.table.TableCellRenderer;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.IMObjectTableModelFactory;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.history.AbstractPagedPatientHistoryTableModel;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.PatientHistoryTableCellRenderer;
import org.openvpms.web.workspace.patient.problem.ProblemHistoryFlattener;
import org.openvpms.web.workspace.patient.problem.ProblemQuery;
import org.openvpms.web.workspace.patient.problem.ProblemTableModel;

public class ProblemBrowser
extends AbstractPatientHistoryBrowser {
    private PagedProblemTableModel pagedModel;
    private static final TableCellRenderer RENDERER = new PatientHistoryTableCellRenderer("ProblemSummary");

    public ProblemBrowser(ProblemQuery query, LayoutContext context) {
        this(query, (ProblemTableModel)IMObjectTableModelFactory.create(ProblemTableModel.class, (LayoutContext)context), context);
    }

    public ProblemBrowser(ProblemQuery query, ProblemTableModel model, LayoutContext context) {
        super(query, model, context);
    }

    public void query() {
        if (this.pagedModel != null) {
            ProblemQuery query = this.getQuery();
            this.pagedModel.setArchetypes(query.getSelectedArchetypes());
            this.pagedModel.setTextSearch(query.getValue());
            this.pagedModel.setSortAscending(query.isSortAscending());
        }
        super.query();
    }

    @Override
    public Act getEvent(Act act) {
        Act result = null;
        if (act != null) {
            if (act.isA("act.patientClinicalProblem")) {
                List acts = this.getObjects();
                int index = acts.indexOf(act);
                if (index >= 0) {
                    ++index;
                    while (index < acts.size()) {
                        Act a = (Act)acts.get(index);
                        if (a.isA("act.patientClinicalEvent")) {
                            result = a;
                        } else if (!a.isA("act.patientClinicalProblem")) {
                            ++index;
                            continue;
                        }
                        break;
                    }
                }
            } else if (act.isA("act.patientClinicalEvent")) {
                result = act;
            } else {
                IMObjectBean bean = IMObjectHelper.getBean((IMObject)act);
                if (bean.hasNode("event") && bean.getSourceRef("event") != null) {
                    result = this.getTableModel().getParent(act, "act.patientClinicalEvent");
                }
            }
        }
        return result;
    }

    public ProblemQuery getQuery() {
        return (ProblemQuery)super.getQuery();
    }

    @Override
    protected PagedIMTable<Act> createTable(IMTableModel<Act> model) {
        ProblemQuery query = this.getQuery();
        this.pagedModel = new PagedProblemTableModel((ProblemTableModel)model, query);
        this.pagedModel.setSortAscending(query.isSortAscending());
        return super.createTable((IMTableModel<Act>)this.pagedModel);
    }

    @Override
    protected void initTable(PagedIMTable<Act> table) {
        super.initTable(table);
        table.getTable().setDefaultRenderer(Object.class, RENDERER);
    }

    @Override
    protected int getPage(Act object) {
        return this.getQuery().getPage(object);
    }

    private static class PagedProblemTableModel
    extends AbstractPagedPatientHistoryTableModel {
        PagedProblemTableModel(ProblemTableModel model, ProblemQuery query) {
            super(model, query.getSelectedArchetypes(), true, new ProblemHistoryFlattener((ArchetypeService)ServiceHelper.getArchetypeService()));
        }
    }
}

