/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.workspace.patient.mr.PatientMedicationActEditor;
import org.openvpms.web.workspace.patient.mr.Prescription;
import org.openvpms.web.workspace.patient.mr.Prescriptions;

public class PrescriptionMedicationActEditor
extends PatientMedicationActEditor {
    private final Prescriptions prescriptions;
    private Prescription prescription;

    public PrescriptionMedicationActEditor(Act act, Act parent, Prescriptions prescriptions, LayoutContext context) {
        super(act, parent, context);
        this.prescriptions = prescriptions;
        this.setProductReadOnly(true);
    }

    @Override
    public IMObjectEditor newInstance() {
        return null;
    }

    public void setPrescription(Act act) {
        boolean readOnly;
        boolean changeLayout = this.prescription != null && act == null || this.prescription == null && act != null;
        boolean bl = readOnly = act != null;
        if (this.prescription != null) {
            this.prescription.removeMedication(this.getObject());
            this.prescription = null;
        }
        if (act != null) {
            Prescription prescription = this.prescriptions.create(act);
            prescription.addMedication(this.getObject());
            this.setProduct((Product)this.getObject(prescription.getProduct()));
            this.setQuantity(prescription.getQuantity());
            this.prescription = prescription;
            String label = prescription.getLabel();
            if (!StringUtils.isEmpty((CharSequence)label)) {
                this.setLabel(label);
            }
        }
        if (changeLayout) {
            this.setDispensedFromPrescription(readOnly);
            this.onLayout();
        }
    }

    public void setPatient(Reference patient) {
        super.setPatient(patient);
        if (this.prescription != null) {
            this.setPrescription(null);
        }
    }

    @Override
    protected void productModified(Product product) {
        super.productModified(product);
        if (this.prescription != null) {
            this.setPrescription(null);
        }
    }
}

