/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.workspace.DocumentActActions;
import org.openvpms.web.component.workspace.DocumentCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.history.PatientHistoryActions;

public class PatientDocumentCRUDWindow
extends DocumentCRUDWindow {
    private static final String MARK_REVIEWED = "button.markReviewed";
    private static final String UNMARK_REVIEWED = "button.unmarkReviewed";

    public PatientDocumentCRUDWindow(Archetypes<DocumentAct> archetypes, Context context, HelpContext help) {
        super(archetypes, (DocumentActActions)PatientDocumentActions.INSTANCE, context, help);
    }

    protected void onCreated(DocumentAct object) {
        if (TypeHelper.isA((IMObject)object, (String)"act.patientInvestigation")) {
            this.confirmCreation(object, "patient.record.create.investigation.title", "patient.record.create.investigation.message", "newInvestigation");
        } else {
            super.onCreated((IMObject)object);
        }
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(MARK_REVIEWED, this.action("act.patientInvestigation", this::markReviewed, "investigation.reviewed.title"));
        buttons.add(UNMARK_REVIEWED, this.action("act.patientInvestigation", this::unmarkReviewed, "investigation.unreviewed.title"));
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(MARK_REVIEWED, enable && PatientHistoryActions.INSTANCE.canReview((Act)this.getObject()));
        buttons.setEnabled(UNMARK_REVIEWED, enable && PatientHistoryActions.INSTANCE.canUnreview((Act)this.getObject()));
    }

    protected void markReviewed(DocumentAct investigation) {
        PatientHistoryActions.INSTANCE.review((Act)investigation);
        this.onRefresh((IMObject)investigation);
    }

    protected void unmarkReviewed(DocumentAct investigation) {
        PatientHistoryActions.INSTANCE.unreview((Act)investigation);
        this.onRefresh((IMObject)investigation);
    }

    private void confirmCreation(final DocumentAct object, String title, String message, String help) {
        ConfirmationDialog dialog = new ConfirmationDialog(Messages.get((String)title), Messages.get((String)message), this.getHelpContext().subtopic(help));
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                PatientDocumentCRUDWindow.super.onCreated((IMObject)object);
            }
        });
        dialog.show();
    }

    private static class PatientDocumentActions
    extends DocumentActActions {
        public static final PatientDocumentActions INSTANCE = new PatientDocumentActions();

        private PatientDocumentActions() {
        }

        public boolean canDelete(DocumentAct act) {
            return super.canDelete((Act)act) && PatientHistoryActions.INSTANCE.canDelete((Act)act);
        }

        public boolean isLocked(DocumentAct act) {
            return super.isLocked((Act)act) || PatientHistoryActions.needsLock((Act)act);
        }
    }
}

