/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.investigation;

import java.util.List;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.system.ServiceHelper;

public class ResultsTableModel
extends DescriptorTableModel<Act> {
    private boolean showTest = true;
    private boolean showCategory = true;
    private ArchetypeNodes nodes = ArchetypeNodes.nodes((String[])new String[]{"date", "test", "categoryName", "status"});

    public ResultsTableModel(String[] shortNames, LayoutContext context) {
        super(context);
        this.setTableColumnModel(this.createColumnModel(shortNames, context));
    }

    public void setObjects(List<Act> objects) {
        boolean newShowTest = false;
        boolean newShowCategory = false;
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        for (Act act : objects) {
            IMObjectBean bean = service.getBean((IMObject)act);
            if (!newShowTest && bean.getTargetRef("test") != null) {
                newShowTest = true;
            }
            if (!newShowCategory && bean.getString("categoryName") != null) {
                newShowCategory = true;
            }
            if (!newShowTest || !newShowCategory) continue;
            break;
        }
        if (newShowTest != this.showTest || newShowCategory != this.showCategory) {
            this.nodes = ArchetypeNodes.nodes((String[])new String[]{"startTime"});
            this.showTest = newShowTest;
            this.showCategory = newShowCategory;
            if (this.showTest) {
                this.nodes.list(new String[]{"test"});
            }
            if (this.showCategory) {
                this.nodes.list(new String[]{"categoryName"});
            }
            this.nodes.list(new String[]{"status"});
            this.setTableColumnModel(this.createColumnModel(new String[]{"act.patientInvestigationResults"}, this.getLayoutContext()));
        }
        super.setObjects(objects);
    }

    protected ArchetypeNodes getArchetypeNodes() {
        return this.nodes;
    }
}

