/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.investigation;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.HttpImageReference;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Label;
import org.apache.commons.lang.StringUtils;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.Hint;
import org.openvpms.web.component.property.DocumentBackedTextProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.servlet.DownloadServlet;
import org.openvpms.web.echo.style.Styles;

public class ResultLayoutStrategy
extends AbstractLayoutStrategy {
    private static final String RESULT = "result";
    private static final String NOTES = "notes";
    private static final ArchetypeNodes NODES = ArchetypeNodes.all().excludeIfEmpty(new String[]{"value", "units", "qualifier", "extremeLowRange", "lowRange", "highRange", "extremeHighRange", "outOfRange", "referenceRange"}).exclude(new String[]{"notes"});

    public ResultLayoutStrategy() {
        this.setArchetypeNodes(new ArchetypeNodes(NODES));
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        DocumentBackedTextProperty notes;
        ComponentState result = this.getResult(object, properties, context);
        if (result != null) {
            this.addComponent(result);
            this.getArchetypeNodes().exclude(new String[]{RESULT});
        }
        if (!StringUtils.isEmpty((String)(notes = new DocumentBackedTextProperty(object, properties.get(NOTES), "longNotes")).getString())) {
            this.addComponent(this.createMultiLineText((Property)notes, 1, 20, Styles.FULL_WIDTH, context));
            this.getArchetypeNodes().exclude(new String[]{NOTES});
        }
        return super.apply(object, properties, parent, context);
    }

    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        ComponentState result = this.getComponent(RESULT);
        if (result == null) {
            ComponentState state = context.getComponentFactory().create(ArchetypeNodes.find(properties, (String)RESULT), object, Hint.height((int)1));
            this.addComponent(state);
        }
        ComponentState notes = this.getComponent(NOTES);
        ComponentGrid grid = this.createGrid(object, properties, context, 2);
        this.addAuditInfo(object, grid, context);
        if (result != null) {
            grid.add(result, 2);
        }
        if (notes != null) {
            grid.add(notes, 2);
        }
        Grid component = this.createGrid(grid);
        component.setWidth(Styles.FULL_WIDTH);
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{component}));
    }

    private ComponentState getResult(IMObject object, PropertySet properties, LayoutContext context) {
        ComponentState state = null;
        DocumentBackedTextProperty property = new DocumentBackedTextProperty(object, properties.get(RESULT), "longResult");
        Label image = this.getImage(object);
        if (this.getLines((Property)property) > 1 || image != null) {
            ComponentState text;
            boolean empty = StringUtils.isEmpty((String)property.getString());
            ComponentState componentState = text = !empty ? this.createMultiLineText((Property)property, 2, 20, Styles.FULL_WIDTH, context) : null;
            state = text != null && image != null ? new ComponentState((Component)ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{image, text.getComponent()}), (Property)property) : (text != null ? text : new ComponentState((Component)image, (Property)property));
        }
        return state;
    }

    private Label getImage(IMObject object) {
        Label result = null;
        IMObjectBean bean = this.getBean(object);
        DocumentAct image = (DocumentAct)bean.getTarget("image", DocumentAct.class);
        if (image != null && image.getDocument() != null) {
            String uri = DownloadServlet.getDocumentURI((Reference)image.getDocument());
            result = LabelFactory.create((ImageReference)new HttpImageReference(uri));
        }
        return result;
    }
}

