/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.investigation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.Test;
import org.openvpms.laboratory.internal.service.OrderValidationService;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.laboratory.service.LaboratoryServices;
import org.openvpms.laboratory.service.OrderValidationStatus;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyComponentEditor;
import org.openvpms.web.component.im.edit.AbstractIMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.act.ParticipationCollectionEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupFilter;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.AbstractEntityQuery;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.investigation.PatientInvestigationActLayoutStrategy;
import org.openvpms.web.workspace.patient.mr.PatientDocumentActEditor;

public class PatientInvestigationActEditor
extends PatientDocumentActEditor {
    private final ParticipationCollectionEditor deviceEditor;
    private final LaboratoryRules rules;
    private final DomainService domainService;
    private List<Entity> tests;
    private boolean enableButton;
    private boolean showDevice;
    private OrderStatusPermission orderStatusPermission = OrderStatusPermission.READ_ONLY;
    private boolean validateOrder = true;
    private String labAlert;
    static final String PROTECTED_DOCUMENT = "protectedDocument";
    private static final String INVESTIGATION_TYPE = "investigationType";
    private static final String GROUP = "group";
    private static final String PRODUCTS = "products";
    private static final String LOCATION = "location";
    private static final String LABORATORY = "laboratory";
    private static final String DEVICE = "device";
    private static final String CLINICIAN = "clinician";
    private static final String ORDER_STATUS = "status2";
    private static final String CONFIRM_ORDER = "confirmOrder";
    private static final String TESTS = "tests";
    private static final String DESCRIPTION = "description";

    public PatientInvestigationActEditor(DocumentAct act, Act parent, LayoutContext context) {
        super(act, (IMObject)parent, context);
        this.rules = (LaboratoryRules)ServiceHelper.getBean(LaboratoryRules.class);
        this.domainService = (DomainService)ServiceHelper.getBean(DomainService.class);
        if (act.isNew()) {
            this.initParticipant(LOCATION, (IMObject)context.getContext().getLocation());
        }
        this.deviceEditor = this.createDeviceCollectionEditor();
        this.addEditor((Editor)this.deviceEditor);
        this.updateOrderStatusPermission(this.getInvestigationType(), this.getLaboratory());
        this.getProperty("document").addModifiableListener(modifiable -> this.onDocumentChanged());
    }

    public void setInvestigationType(Entity investigationType) {
        this.checkEditable();
        this.setParticipant(INVESTIGATION_TYPE, investigationType);
    }

    public void addProduct(Product product) {
        this.checkEditable();
        List refs = this.getBean((IMObject)this.getObject()).getTargetRefs(PRODUCTS);
        if (!refs.contains(product.getObjectReference())) {
            this.addParticipant(PRODUCTS, (Entity)product);
            this.onLayout();
        }
    }

    public void removeProduct(Product product) {
        this.checkEditable();
        if (this.removeParticipant(PRODUCTS, (Entity)product)) {
            this.onLayout();
        }
    }

    public void setLocation(Party location) {
        this.setParticipant(LOCATION, (Entity)location);
    }

    public Party getLocation() {
        return (Party)this.getParticipant(LOCATION);
    }

    public Reference getLocationRef() {
        return this.getParticipantRef(LOCATION);
    }

    public void save() {
        boolean isNew = this.getObject().isNew();
        super.save();
        if (isNew) {
            this.enableButton = true;
            this.onLayout();
        }
    }

    @Override
    public IMObjectEditor newInstance() {
        return new PatientInvestigationActEditor((DocumentAct)this.reload((IMObject)this.getObject()), (Act)this.getParent(), this.getLayoutContext());
    }

    public boolean canAddTest(Party patient, Entity test) {
        List<Entity> tests;
        Reference ref;
        IMObjectBean bean;
        boolean result = false;
        if (test.isActive() && this.canEdit() && (bean = this.getBean((IMObject)test)).getBoolean(GROUP) && Objects.equals(this.getPatientRef(), patient.getObjectReference()) && (ref = bean.getTargetRef(INVESTIGATION_TYPE)) != null && ref.equals((Object)this.getInvestigationTypeRef()) && !(tests = this.getTests()).contains(test) && this.canGroup(tests)) {
            result = true;
        }
        return result;
    }

    public List<Entity> getTests() {
        if (this.tests == null) {
            this.tests = this.getParticipants(TESTS);
        }
        return this.tests;
    }

    public void addTest(Entity test) {
        this.checkEditable();
        this.addParticipant(TESTS, test);
        this.tests = null;
        this.onTestChanged();
    }

    public void removeTest(Entity test) {
        this.checkEditable();
        this.removeParticipant(TESTS, test);
        this.tests = null;
        this.onTestChanged();
    }

    public Entity getInvestigationType() {
        return this.getParticipant(INVESTIGATION_TYPE);
    }

    public Reference getInvestigationTypeRef() {
        return this.getParticipantRef(INVESTIGATION_TYPE);
    }

    public Entity getLaboratory() {
        return this.getParticipant(LABORATORY);
    }

    public Entity getDevice() {
        return this.getParticipant(DEVICE);
    }

    public void setDevice(Entity device) {
        this.setParticipant(DEVICE, device);
    }

    public Reference getDeviceRef() {
        return this.getParticipantRef(DEVICE);
    }

    public boolean confirmOrder() {
        boolean result = false;
        if (this.canEdit()) {
            result = this.getProperty(CONFIRM_ORDER).getBoolean(false);
        }
        return result;
    }

    public String getOrderStatus() {
        return this.getObject().getStatus2();
    }

    public boolean canEdit() {
        String status = this.getOrderStatus();
        return "PENDING".equals(status) && !this.isLocked();
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        PropertyComponentEditor orderStatusEditor = this.createOrderStatus();
        PatientInvestigationActLayoutStrategy strategy = new PatientInvestigationActLayoutStrategy(this.getDocumentEditor(), this.getVersionsEditor(), this.showDevice ? this.deviceEditor : null, orderStatusEditor, this.isLocked());
        strategy.setEnableButton(this.enablePrintForm());
        return strategy;
    }

    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        this.monitorParticipation(INVESTIGATION_TYPE, entity -> this.onInvestigationTypeChanged());
        this.monitorParticipation(DEVICE, entity -> this.setValidateOrder());
        this.monitorParticipation(CLINICIAN, entity -> this.setValidateOrder());
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateTests(validator) && this.validateOrder(validator);
    }

    protected boolean validateStartEndTimes(Validator validator) {
        return true;
    }

    protected void doDelete() {
        this.deleteChildDocuments();
        super.doDelete();
    }

    protected LaboratoryServices getLaboratoryServices() {
        return (LaboratoryServices)ServiceHelper.getBean(LaboratoryServices.class);
    }

    protected OrderValidationService getValidationService() {
        return (OrderValidationService)ServiceHelper.getBean(OrderValidationService.class);
    }

    private void onDocumentChanged() {
        this.getProperty(PROTECTED_DOCUMENT).setValue((Object)true);
        if ("SENT".equals(this.getOrderStatus())) {
            this.getProperty(ORDER_STATUS).setValue((Object)"RECEIVED");
        }
    }

    private void checkEditable() {
        if (!this.canEdit()) {
            throw new IllegalStateException("Cannot change investigation with status " + this.getObject().getStatus2());
        }
    }

    private void onTestChanged() {
        this.setValidateOrder();
        Entity laboratory = this.getLaboratory();
        if (laboratory != null) {
            List<Entity> tests = this.getTests();
            this.showDevice = this.showDevice(tests);
            if (!tests.isEmpty()) {
                boolean confirm = this.needsOrderConfirmation(laboratory, tests);
                Property confirmOrder = this.getProperty(CONFIRM_ORDER);
                if (confirm) {
                    confirmOrder.setValue((Object)true);
                } else {
                    confirmOrder.setValue(null);
                }
            }
            if (this.showDevice) {
                if (this.getDeviceRef() == null) {
                    this.setDefaultDevice();
                }
            } else {
                this.setDevice(null);
            }
        }
        this.onLayout();
    }

    private void setDefaultDevice() {
        Entity investigationType = this.getInvestigationType();
        if (investigationType != null) {
            Reference locationRef = this.getLocationRef();
            IMObjectBean bean = this.getBean((IMObject)investigationType);
            List devices = bean.getTargets("devices", Entity.class, Policies.active());
            Entity match = null;
            for (Entity device : devices) {
                IMObjectBean deviceBean = this.getBean((IMObject)device);
                List locations = deviceBean.getTargetRefs("locations");
                if (!locations.isEmpty() && !locations.contains(locationRef)) continue;
                if (match == null) {
                    match = device;
                    continue;
                }
                match = null;
                break;
            }
            this.setDevice(match);
        }
    }

    private boolean showDevice(List<Entity> tests) {
        boolean result = false;
        for (Entity test : tests) {
            IMObjectBean bean = this.getBean((IMObject)test);
            Test.UseDevice use = this.getUseDevice(bean);
            if (use != Test.UseDevice.YES && use != Test.UseDevice.OPTIONAL) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean canGroup(List<Entity> tests) {
        for (Entity test : tests) {
            IMObjectBean bean = this.getBean((IMObject)test);
            if (bean.getBoolean(GROUP)) continue;
            return false;
        }
        return true;
    }

    private LaboratoryService getLaboratoryService(Entity laboratory) {
        return this.getLaboratoryServices().getService(laboratory);
    }

    private boolean needsOrderConfirmation(Entity laboratory, List<Entity> tests) {
        boolean result;
        block4: {
            result = false;
            if (!tests.isEmpty() && !this.isHL7(tests)) {
                try {
                    LaboratoryService service = this.getLaboratoryService(laboratory);
                    if (service == null) break block4;
                    for (Entity entity : tests) {
                        Test test = (Test)this.domainService.create((IMObject)entity, Test.class);
                        if (!service.confirmOrders(test)) continue;
                        result = true;
                        break;
                    }
                }
                catch (Throwable exception) {
                    ErrorHelper.show((Throwable)exception);
                }
            }
        }
        return result;
    }

    private boolean isHL7(List<Entity> tests) {
        for (Entity test : tests) {
            if (!test.isA("entity.laboratoryTestHL7")) continue;
            return true;
        }
        return false;
    }

    private void onInvestigationTypeChanged() {
        Entity investigationType = this.getInvestigationType();
        this.tests = null;
        this.setValidateOrder();
        CollectionProperty tests = this.getCollectionProperty(TESTS);
        boolean changed = false;
        for (Object value : tests.getValues()) {
            tests.remove(value);
            changed = true;
        }
        CollectionProperty products = this.getCollectionProperty(PRODUCTS);
        for (Object value : products.getValues()) {
            products.remove(value);
            changed = true;
        }
        boolean layout = this.updateLaboratory(investigationType);
        if (investigationType != null) {
            String description = this.getLaboratory() == null ? investigationType.getDescription() : null;
            this.getProperty(DESCRIPTION).setValue((Object)description);
        }
        if (layout || changed) {
            this.onLayout();
        }
    }

    private void setValidateOrder() {
        this.validateOrder = true;
    }

    private boolean validateTests(Validator validator) {
        if (this.canEdit()) {
            List<Entity> tests = this.getTests();
            Entity laboratory = this.getLaboratory();
            Party location = this.getLocation();
            Entity device = this.getDevice();
            if (!tests.isEmpty()) {
                Entity investigationType = this.getInvestigationType();
                if (investigationType == null) {
                    validator.add((Modifiable)this, Messages.format((String)"property.error.required", (Object[])new Object[]{this.getDescriptor(INVESTIGATION_TYPE).getDisplayName()}));
                } else if (location == null) {
                    validator.add((Modifiable)this, Messages.format((String)"property.error.required", (Object[])new Object[]{this.getDescriptor(LOCATION).getDisplayName()}));
                } else {
                    Entity typeLaboratory = this.rules.getLaboratory(investigationType);
                    Entity locationLaboratory = this.getLaboratory(investigationType, location);
                    if (TypeHelper.isA((IMObject)typeLaboratory, (String)"entity.laboratoryService*") && locationLaboratory == null) {
                        String message = Messages.format((String)"investigation.test.noLaboratoryForLocation", (Object[])new Object[]{investigationType.getName(), typeLaboratory.getName(), location.getName()});
                        validator.add((Modifiable)this, new ValidatorError(message));
                    } else if (!Objects.equals(locationLaboratory, laboratory)) {
                        String typeLabName = locationLaboratory != null ? locationLaboratory.getName() : Messages.get((String)"imobject.none");
                        String labName = laboratory != null ? laboratory.getName() : Messages.get((String)"imobject.none");
                        String message = Messages.format((String)"investigation.test.laboratoryInvestigationTypeMismatch", (Object[])new Object[]{typeLabName, investigationType.getName(), labName});
                        validator.add((Modifiable)this, new ValidatorError(message));
                    } else if (this.validateDevice(validator, device, laboratory, location)) {
                        this.validateTests(validator, tests, investigationType, laboratory, location, device);
                    }
                }
            } else if (laboratory != null) {
                String message = Messages.format((String)"investigation.test.testRequiredForLab", (Object[])new Object[]{laboratory.getName()});
                validator.add((Modifiable)this, new ValidatorError(message));
            } else if (device != null) {
                String message = Messages.format((String)"investigation.test.testRequiredForDevice", (Object[])new Object[0]);
                validator.add((Modifiable)this, new ValidatorError(message));
            }
        }
        return validator.isValid();
    }

    private boolean validateOrder(Validator validator) {
        if (this.validateOrder && this.canEdit()) {
            OrderValidationService.ValidationStatus status;
            AlertListener listener = this.getAlertListener();
            if (listener != null && this.labAlert != null) {
                listener.cancel(this.labAlert);
            }
            if ((status = this.getValidationService().validate(this.getObject())).getStatus() == OrderValidationStatus.Status.ERROR) {
                if (listener != null) {
                    String message = Messages.format((String)"investigation.validation.error", (Object[])new Object[]{status.getName(), status.getMessage()});
                    this.labAlert = listener.onAlert(message, AlertListener.Category.ERROR);
                }
            } else if (status.getStatus() == OrderValidationStatus.Status.WARNING) {
                if (listener != null) {
                    String message = Messages.format((String)"investigation.validation.warning", (Object[])new Object[]{status.getName(), status.getMessage()});
                    this.labAlert = listener.onAlert(message);
                }
            } else {
                this.validateOrder = false;
            }
        }
        return validator.isValid();
    }

    private boolean validateDevice(Validator validator, Entity device, Entity laboratory, Party location) {
        if (device != null) {
            IMObjectBean deviceBean = this.getBean((IMObject)device);
            if (laboratory == null) {
                validator.add((Modifiable)this, Messages.format((String)"investigation.test.laboratoryRequired", (Object[])new Object[]{device.getName()}));
            } else if (!Objects.equals(laboratory.getObjectReference(), deviceBean.getTargetRef(LABORATORY))) {
                validator.add((Modifiable)this, Messages.format((String)"investigation.test.laboratoryDeviceMismatch", (Object[])new Object[]{device.getName(), laboratory.getName()}));
            } else if (!this.rules.canUseDeviceAtLocation(device, location)) {
                validator.add((Modifiable)this, Messages.format((String)"investigation.test.notAtLocation", (Object[])new Object[]{device.getName(), location.getName()}));
            }
        }
        return validator.isValid();
    }

    private void validateTests(Validator validator, List<Entity> tests, Entity investigationType, Entity laboratory, Party location, Entity device) {
        Reference investigationTypeRef = investigationType.getObjectReference();
        for (Entity test : tests) {
            if (!test.isActive()) {
                validator.add((Modifiable)this, Messages.format((String)"investigation.test.invactive", (Object[])new Object[]{test.getName()}));
                break;
            }
            IMObjectBean bean = this.getBean((IMObject)test);
            if (!Objects.equals(investigationTypeRef, bean.getTargetRef(INVESTIGATION_TYPE))) {
                validator.add((Modifiable)this, Messages.format((String)"investigation.test.unsupported", (Object[])new Object[]{test.getName(), investigationType.getName()}));
                break;
            }
            Test.UseDevice use = this.getUseDevice(bean);
            if (use == Test.UseDevice.NO && device != null) {
                validator.add((Modifiable)this, Messages.format((String)"investigation.test.unsupportedDevice", (Object[])new Object[]{test.getName()}));
                break;
            }
            if (use == Test.UseDevice.YES && device == null) {
                validator.add((Modifiable)this, Messages.format((String)"investigation.test.deviceRequired", (Object[])new Object[]{test.getName()}));
                break;
            }
            if (tests.size() > 1 && !bean.getBoolean(GROUP)) {
                validator.add((Modifiable)this, Messages.format((String)"investigation.test.noGroup", (Object[])new Object[]{test.getName()}));
                continue;
            }
            if (laboratory == null || this.rules.canUseLaboratoryAtLocation(laboratory, location)) continue;
            validator.add((Modifiable)this, Messages.format((String)"investigation.test.notAtLocation", (Object[])new Object[]{test.getName(), location.getName()}));
            break;
        }
    }

    private boolean updateOrderStatusPermission(Entity investigationType, Entity laboratory) {
        OrderStatusPermission oldPermission = this.orderStatusPermission;
        this.orderStatusPermission = investigationType != null && laboratory == null ? OrderStatusPermission.EDITABLE : OrderStatusPermission.READ_ONLY;
        return this.orderStatusPermission != oldPermission;
    }

    private boolean updateLaboratory(Entity investigationType) {
        boolean result = false;
        Entity laboratory = null;
        if (investigationType != null) {
            laboratory = this.getLaboratory(investigationType);
        }
        boolean oldShowDevice = this.showDevice;
        this.setValidateOrder();
        this.setParticipant(LABORATORY, laboratory);
        this.setParticipant(DEVICE, null);
        if (this.updateOrderStatusPermission(investigationType, laboratory) || oldShowDevice != this.showDevice) {
            result = true;
        }
        return result;
    }

    private void deleteChildDocuments() {
        IMObjectBean bean = this.getBean((IMObject)this.getObject());
        for (Act results : bean.getTargets("results", Act.class)) {
            IMObjectBean resultsBean = this.getBean((IMObject)results);
            this.deleteDocument(resultsBean, "longNotes");
            for (Act result : resultsBean.getTargets("items", Act.class)) {
                this.deleteResultDocuments(result);
            }
        }
    }

    private void deleteResultDocuments(Act result) {
        IMObjectBean bean = this.getBean((IMObject)result);
        this.deleteDocument(bean, "longResult");
        this.deleteDocument(bean, "longNotes");
        this.deleteDocument(bean, "image");
    }

    private void deleteDocument(IMObjectBean bean, String node) {
        DocumentAct act = (DocumentAct)bean.getTarget(node, DocumentAct.class);
        if (act != null) {
            IArchetypeService service = this.getService();
            Reference document = act.getDocument();
            if (document != null) {
                act.setDocument(null);
                service.save((IMObject)act);
                service.remove(document);
            }
        }
    }

    private Entity getLaboratory(Entity investigationType) {
        return this.getLaboratory(investigationType, this.getLocation());
    }

    private Entity getLaboratory(Entity investigationType, Party location) {
        return location != null ? this.rules.getLaboratory(investigationType, location) : null;
    }

    private boolean enablePrintForm() {
        return this.enableButton || !this.getObject().isNew();
    }

    private ParticipationCollectionEditor createDeviceCollectionEditor() {
        CollectionProperty property = this.getCollectionProperty(DEVICE);
        return new ParticipationCollectionEditor(property, (IMObject)this.getObject(), this.getLayoutContext()){

            protected IMObjectEditor createEditor(IMObject object, final LayoutContext context) {
                return new ParticipationEditor<Entity>((Participation)object, (Act)this.getObject(), context){

                    protected IMObjectReferenceEditor<Entity> createEntityEditor(Property property) {
                        return new DeviceReferenceEditor(property, context);
                    }
                };
            }
        };
    }

    private Test.UseDevice getUseDevice(IMObjectBean test) {
        String useDevice;
        String string = useDevice = test.hasNode("useDevice") ? test.getString("useDevice") : null;
        if (useDevice == null) {
            return Test.UseDevice.NO;
        }
        return Test.UseDevice.valueOf((String)useDevice);
    }

    private PropertyComponentEditor createOrderStatus() {
        PropertyComponentEditor result = null;
        Property property = this.getProperty(ORDER_STATUS);
        if (this.orderStatusPermission != OrderStatusPermission.READ_ONLY) {
            NodeLookupQuery query = new NodeLookupQuery((IMObject)this.getObject(), property);
            query = new LookupFilter((LookupQuery)query, false, new String[]{"CONFIRM", "CONFIRM_DEFERRED", "ERROR"});
            LookupField field = LookupFieldFactory.create((Property)property, (LookupQuery)query);
            result = new PropertyComponentEditor(property, (Component)field);
        }
        return result;
    }

    private static enum OrderStatusPermission {
        EDITABLE,
        READ_ONLY;

    }

    private class DeviceReferenceEditor
    extends AbstractIMObjectReferenceEditor<Entity> {
        DeviceReferenceEditor(Property property, LayoutContext context) {
            super(property, PatientInvestigationActEditor.this.getParent(), context);
        }

        protected Query<Entity> createQuery(String name) {
            DeviceQuery query = new DeviceQuery();
            query.setValue(name);
            return query;
        }

        protected boolean isValidReference(Reference reference) {
            return true;
        }

        private class DeviceQuery
        extends AbstractEntityQuery<Entity> {
            DeviceQuery() {
                super(new String[]{"entity.laboratoryDevice*"});
                this.setAuto(true);
            }

            protected ResultSet<Entity> createResultSet(SortConstraint[] sort) {
                List matches = new ArrayList();
                Entity investigationType = PatientInvestigationActEditor.this.getInvestigationType();
                if (investigationType != null) {
                    BaseArchetypeConstraint.State active = this.getActive();
                    Policy policy = active == BaseArchetypeConstraint.State.ACTIVE ? Policies.active() : (active == BaseArchetypeConstraint.State.INACTIVE ? Policies.newPolicy(Relationship.class).inactiveObjects().build() : Policies.all());
                    matches = this.getBean((IMObject)investigationType).getTargets("devices", Entity.class, policy);
                }
                final Reference location = PatientInvestigationActEditor.this.getLocationRef();
                return new FilteredResultSet<Entity>((ResultSet)new ListResultSet(matches, this.getMaxResults())){

                    protected void filter(Entity object, List<Entity> results) {
                        IMObjectBean bean;
                        List locations;
                        if (location != null && ((locations = (bean = DeviceQuery.this.getBean((IMObject)object)).getTargetRefs("locations")).isEmpty() || locations.contains(location))) {
                            results.add(object);
                        }
                    }
                };
            }
        }
    }
}

