/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.investigation;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.im.doc.DocumentViewer;
import org.openvpms.web.component.im.doc.Downloader;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.investigation.CheckResultsViewer;
import org.openvpms.web.workspace.patient.investigation.ExternalResultsViewer;
import org.openvpms.web.workspace.patient.investigation.InvestigationDownloader;
import org.openvpms.web.workspace.patient.investigation.ResultChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvestigationViewer
extends DocumentViewer {
    private static final Logger log = LoggerFactory.getLogger(InvestigationViewer.class);

    public InvestigationViewer(DocumentAct act, boolean link, LayoutContext context) {
        super(act, link, context);
    }

    public InvestigationViewer(DocumentAct act, boolean link, boolean template, LayoutContext context) {
        super(act, link, template, context);
    }

    public InvestigationViewer(Reference reference, IMObject parent, boolean link, LayoutContext context) {
        super(reference, parent, link, context);
    }

    public Component getComponent() {
        Component result = null;
        DocumentAct parent = (DocumentAct)this.getParent();
        if (parent != null && !parent.isNew()) {
            Component external;
            Component document = this.getDocument();
            Component component = external = this.link() ? this.getExternalResults() : null;
            if (document != null && external != null) {
                result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{document, external});
            } else if (document != null) {
                result = document;
            } else if (external != null) {
                result = external;
            }
        }
        if (result == null) {
            result = this.getPlaceholder();
        }
        return result;
    }

    protected Component getDocument() {
        IMObjectBean bean;
        Component result = super.getDocument();
        if (result == null && this.getParent() != null && !(bean = this.getBean()).getValues("results").isEmpty()) {
            result = this.createDownloader().getComponent();
        }
        return result;
    }

    protected Downloader createDownloader() {
        return new InvestigationDownloader((DocumentAct)this.getParent(), this.getContext().getContext(), (FileNameFormatter)ServiceHelper.getBean(FileNameFormatter.class), (ReportFactory)ServiceHelper.getBean(ReportFactory.class));
    }

    private Component getExternalResults() {
        IMObjectBean bean = this.getBean();
        DocumentAct investigation = (DocumentAct)this.getParent();
        Component result = null;
        Entity laboratory = this.getLaboratory(bean);
        if (laboratory != null && laboratory.isActive()) {
            try {
                if (bean.getBoolean("externalResults")) {
                    ExternalResultsViewer viewer = new ExternalResultsViewer(investigation);
                    result = viewer.getComponent();
                } else {
                    ResultChecker resultChecker = new ResultChecker(investigation);
                    if (resultChecker.canCheckResults()) {
                        CheckResultsViewer viewer = new CheckResultsViewer(resultChecker);
                        result = viewer.getComponent();
                    }
                }
            }
            catch (Throwable exception) {
                log.error("Failed to get results viewer for laboratory={}: {}", new Object[]{laboratory.getName(), exception.getMessage(), exception});
            }
            return result;
        }
        return result;
    }

    private Entity getLaboratory(IMObjectBean bean) {
        IMObjectCache cache = this.getContext().getCache();
        return (Entity)cache.get(bean.getTargetRef("laboratory"));
    }
}

