/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.List;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.workspace.customer.credit.GapPaymentTillReferenceEditor;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentLayoutStrategy;
import org.openvpms.web.workspace.customer.payment.PaymentStatus;

public class GapPaymentEditor
extends CustomerPaymentEditor {
    private final Party gapLocation;
    private final boolean tillRequired;
    private Entity gapTill;
    private GapPaymentTillReferenceEditor tillEditor;

    GapPaymentEditor(FinancialAct act, IMObject parent, LayoutContext context, BigDecimal invoice, Party gapLocation, Entity gapTill, boolean tillRequired) {
        super(act, parent, context, invoice);
        this.gapLocation = gapLocation;
        this.gapTill = gapTill;
        this.tillRequired = tillRequired;
        act.setStatus("POSTED");
        this.setExpectedAmount(invoice);
        if (gapTill == null && tillRequired) {
            this.tillEditor = new GapPaymentTillReferenceEditor(gapLocation, context);
            this.tillEditor.addModifiableListener(modifiable -> {
                this.gapTill = (Entity)this.tillEditor.getObject();
            });
            this.addEditor((Editor)this.tillEditor);
        }
    }

    @Override
    public IMObjectEditor newInstance() {
        return new GapPaymentEditor(this.reloadPayment(), this.getParent(), this.getLayoutContext(), this.getInvoiceAmount(), this.gapLocation, this.getGapPaymentTill(), this.tillRequired);
    }

    public Entity getGapPaymentTill() {
        return this.gapTill;
    }

    protected PropertySet createPropertySet(IMObject object, ArchetypeDescriptor archetype, Variables variables) {
        return new PropertySetBuilder(object, archetype, variables).removeArchetypesFromRange("items", new String[]{"act.customerAccountPaymentPP", "act.customerAccountRefundPP"}).build();
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new PaymentLayoutStrategy((IMObjectCollectionEditor)this.getItems(), this.getPaymentStatus());
    }

    void setGapPaymentTill(Entity gapTill) {
        this.tillEditor.setObject(gapTill);
    }

    private class PaymentLayoutStrategy
    extends CustomerPaymentLayoutStrategy {
        PaymentLayoutStrategy(IMObjectCollectionEditor editor, PaymentStatus status) {
            super(editor, status);
            this.getArchetypeNodes().exclude(new String[]{"status"});
        }

        protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context) {
            ComponentGrid grid = super.createGrid(object, properties, context);
            if (GapPaymentEditor.this.tillEditor != null) {
                grid.add(new ComponentState[]{new ComponentState((PropertyEditor)GapPaymentEditor.this.tillEditor)});
            }
            return grid;
        }
    }
}

