/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.DocumentJobManager;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.im.report.Reporter;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.mail.MailDialogFactory;
import org.openvpms.web.component.mail.MailEditor;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimHelper;
import org.openvpms.web.workspace.patient.insurance.claim.InsurerMailContext;

public class ClaimMailer {
    private final ArchetypeService service = ServiceHelper.getArchetypeService();
    private final ClaimHelper helper;
    private final ReporterFactory reporterFactory = (ReporterFactory)ServiceHelper.getBean(ReporterFactory.class);
    private final DocumentJobManager jobManager = (DocumentJobManager)ServiceHelper.getBean(DocumentJobManager.class);

    public ClaimMailer() {
        this.helper = new ClaimHelper(this.service);
    }

    public void mail(Claim claim, Act act, List<IMObject> attachments, Context context, HelpContext help, Consumer<MailDialog> listener) {
        InsurerMailContext mailContext = new InsurerMailContext(context, help);
        MailDialogFactory factory = (MailDialogFactory)ServiceHelper.getBean(MailDialogFactory.class);
        MailDialog dialog = factory.create((MailContext)mailContext, (LayoutContext)new DefaultLayoutContext(context, help));
        dialog.getMailEditor().setObject((Object)act);
        this.mail(claim, attachments.iterator(), dialog, context, listener);
    }

    private void mail(Claim claim, Iterator<IMObject> attachments, MailDialog dialog, Context context, Consumer<MailDialog> listener) {
        if (attachments.hasNext()) {
            IMObject object = attachments.next();
            MailEditor editor = dialog.getMailEditor();
            if (object.isA("act.patientInsuranceClaimAttachment")) {
                this.addAttachment(editor, (DocumentAct)object);
                this.mail(claim, attachments, dialog, context, listener);
            } else {
                this.generateAttachment(object, claim, context, document -> {
                    editor.addAttachment(document);
                    this.mail(claim, attachments, dialog, context, listener);
                });
            }
        } else {
            listener.accept(dialog);
        }
    }

    private void addAttachment(MailEditor editor, DocumentAct act) {
        Document document;
        Document document2 = document = act.getDocument() != null ? (Document)this.service.get(act.getDocument(), Document.class) : null;
        if (document != null) {
            editor.addAttachment(document);
        }
    }

    private void generateAttachment(IMObject object, Claim claim, Context context, Consumer<Document> listener) {
        DocumentTemplateLocator locator = this.helper.getDocumentTemplateLocator(claim, object, context);
        Reporter reporter = this.reporterFactory.create(object, locator, Reporter.class);
        reporter.setFields(ReportContextFactory.create((Context)context));
        Job job = JobBuilder.newJob((String)"Claim attachment", (User)context.getUser()).get(() -> reporter.getDocument("application/pdf", true)).completed(listener).build();
        this.jobManager.runInteractive(job, Messages.get((String)"document.generateattachment.title"), Messages.get((String)"document.generateattachment.cancel"));
    }
}

