/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.Date;
import java.util.function.Consumer;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.AbstractRemoveConfirmationHandler;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.RemoveConfirmationHandler;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.history.PatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;
import org.openvpms.web.workspace.patient.insurance.claim.AttachmentCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.Charges;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimItemEditor;
import org.openvpms.web.workspace.patient.problem.ProblemBrowser;
import org.openvpms.web.workspace.patient.problem.ProblemQuery;

class ClaimItemCollectionEditor
extends ActRelationshipCollectionEditor {
    private final Party customer;
    private final Party patient;
    private final Charges charges;
    private final AttachmentCollectionEditor attachments;
    private static final String ADD_VISIT = "button.addvisit";
    private static final String ADD_PROBLEM = "button.addproblem";

    public ClaimItemCollectionEditor(CollectionProperty property, Act act, Party customer, Party patient, Charges charges, AttachmentCollectionEditor attachments, LayoutContext context) {
        super(property, act, (LayoutContext)new DefaultLayoutContext(context));
        this.customer = customer;
        this.patient = patient;
        this.charges = charges;
        this.attachments = attachments;
        this.setRemoveConfirmationHandler((RemoveConfirmationHandler)new AbstractRemoveConfirmationHandler(){

            public void apply(IMObject object, IMObjectCollectionEditor collection) {
                IMObjectEditor editor = ClaimItemCollectionEditor.this.getEditor(object);
                if (editor instanceof ClaimItemEditor) {
                    ClaimItemCollectionEditor.this.remove((ClaimItemEditor)editor);
                }
                super.apply(object, collection);
            }
        });
    }

    public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        return new ClaimItemEditor((Act)object, (Act)this.getObject(), this.customer, this.patient, this.charges, this.attachments, context);
    }

    public Date getMinTreatmentDate() {
        Date result = null;
        for (Act condition : this.getCurrentActs()) {
            Date startTime = condition.getActivityStartTime();
            if (startTime == null || result != null && result.compareTo(startTime) <= 0) continue;
            result = startTime;
        }
        return result;
    }

    public Date getMaxTreatmentDate() {
        Date result = null;
        for (Act condition : this.getCurrentActs()) {
            Date endTime = condition.getActivityEndTime();
            if (endTime == null || result != null && result.compareTo(endTime) >= 0) continue;
            result = endTime;
        }
        return result;
    }

    protected void enableNavigation(ButtonSet buttons, boolean enable, boolean enableAdd) {
        super.enableNavigation(buttons, enable, enableAdd);
        buttons.setEnabled(ADD_VISIT, enableAdd);
        buttons.setEnabled(ADD_PROBLEM, enableAdd);
    }

    protected ButtonRow createControls(FocusGroup focus) {
        ButtonRow row = super.createControls(focus);
        ButtonSet buttons = row.getButtons();
        Button visit = buttons.create(ADD_VISIT, this::onAddVisit);
        buttons.add(visit, 1);
        Button problem = buttons.create(ADD_PROBLEM, this::onAddProblem);
        buttons.add(problem, 2);
        return row;
    }

    protected void onAddVisit() {
        LayoutContext context = this.getContext();
        PatientHistoryQuery query = new PatientHistoryQuery(this.patient, context.getPreferences());
        PatientHistoryBrowser browser = new PatientHistoryBrowser(query, context);
        this.selectFromBrowser((Browser<Act>)browser, "act.patientClinicalEvent", this::addVisit);
    }

    protected void onAddProblem() {
        LayoutContext context = this.getContext();
        ProblemQuery query = new ProblemQuery(this.patient, context.getPreferences());
        ProblemBrowser browser = new ProblemBrowser(query, context);
        this.selectFromBrowser((Browser<Act>)browser, "act.patientClinicalProblem", this::addProblem);
    }

    protected void addVisit(Act visit) {
        Act object = (Act)this.create();
        if (object != null) {
            object.setActivityStartTime(visit.getActivityStartTime());
            object.setActivityEndTime(visit.getActivityEndTime());
            IMObjectBean bean = this.getBean((IMObject)visit);
            this.addAttachments(bean);
            this.add((IMObject)object);
            String description = visit.getTitle();
            if (StringUtils.isEmpty((CharSequence)description)) {
                description = ServiceHelper.getLookupService().getName((IMObject)visit, "reason");
            }
            object.setDescription(description);
            IMObjectEditor editor = this.getEditor((IMObject)object);
            if (editor instanceof ClaimItemEditor) {
                ClaimItemEditor claimItemEditor = (ClaimItemEditor)editor;
                for (Act charge : bean.getTargets("chargeItems", Act.class)) {
                    claimItemEditor.addCharge(charge);
                }
            }
            this.setModified(object, true);
            this.refresh();
            this.setSelected((IMObject)object);
            this.edit((IMObject)object);
        }
    }

    protected void addProblem(Act problem) {
        Act object = (Act)this.create();
        if (object != null) {
            Lookup presentingComplaint;
            object.setActivityStartTime(problem.getActivityStartTime());
            object.setActivityEndTime(problem.getActivityEndTime());
            IMObjectBean bean = this.getBean((IMObject)problem);
            Lookup diagnosis = bean.getLookup("reason");
            if (diagnosis != null) {
                object.setReason(diagnosis.getCode());
            }
            if ((presentingComplaint = bean.getLookup("presentingComplaint")) != null) {
                object.setDescription(presentingComplaint.getName());
            }
            object.setStatus(problem.getStatus());
            this.addAttachments(bean);
            this.add((IMObject)object);
            IMObjectEditor editor = this.getEditor((IMObject)object);
            if (editor instanceof ClaimItemEditor) {
                ClaimItemEditor claimItemEditor = (ClaimItemEditor)editor;
                for (Act event : bean.getSources("events", Act.class)) {
                    IMObjectBean eventBean = this.getBean((IMObject)event);
                    for (Act charge : eventBean.getTargets("chargeItems", Act.class)) {
                        claimItemEditor.addCharge(charge);
                    }
                }
            }
            this.setModified(object, true);
            this.refresh();
            this.setSelected((IMObject)object);
            this.edit((IMObject)object);
        }
    }

    protected void remove(ClaimItemEditor editor) {
        for (Act charge : editor.getCharges()) {
            this.charges.remove(charge);
        }
    }

    protected AttachmentCollectionEditor getAttachments() {
        return this.attachments;
    }

    private void selectFromBrowser(Browser<Act> browser, final String archetype, final Consumer<Act> consumer) {
        String title = Messages.format((String)"imobject.select.title", (Object[])new Object[]{DescriptorHelper.getDisplayName((String)archetype, (ArchetypeService)this.getService())});
        BrowserDialog<Act> dialog = new BrowserDialog<Act>(title, BrowserDialog.OK_CANCEL, browser, this.getContext().getHelpContext()){

            public boolean isSelected() {
                return TypeHelper.isA((IMObject)((IMObject)this.getSelected()), (String)archetype);
            }
        };
        dialog.setCloseOnSelection(false);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener((BrowserDialog)dialog){
            final /* synthetic */ BrowserDialog val$dialog;
            {
                this.val$dialog = browserDialog;
            }

            public void onOK() {
                consumer.accept(this.val$dialog.getSelected());
            }
        });
        dialog.show();
    }

    private void addAttachments(IMObjectBean bean) {
        for (Reference ref : bean.getTargetRefs("items")) {
            DocumentAct document;
            if (!ref.isA(new String[]{"act.patientDocumentForm", "act.patientDocumentImage", "act.patientDocumentLetter", "act.patientDocumentAttachment", "act.patientInvestigation"}) || (document = (DocumentAct)IMObjectHelper.getObject((Reference)ref)) == null) continue;
            this.attachments.addDocument(document);
        }
    }
}

