/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.CachingReadOnlyArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.SoftRefIMObjectCache;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimContext;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimHelper;

class Charges {
    private final ClaimContext claimContext;
    private final IMObjectCache cache;
    private final IArchetypeService service;
    private final CustomerAccountRules rules;
    private final ClaimHelper claimHelper;
    private final Map<Reference, Act> charges = new HashMap<Reference, Act>();

    public Charges(ClaimContext claimContext) {
        this.claimContext = claimContext;
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        this.cache = new SoftRefIMObjectCache((ArchetypeService)service);
        this.service = new CachingReadOnlyArchetypeService(this.cache, (IArchetypeService)service);
        this.rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
        this.claimHelper = new ClaimHelper((ArchetypeService)this.service);
    }

    public boolean getChargesMustBePaid() {
        return !this.claimContext.isGapClaim();
    }

    public boolean isGapClaimAvailable() {
        return this.claimContext.supportsGapClaims();
    }

    public void add(Act item) {
        this.charges.put(item.getObjectReference(), item);
    }

    public void remove(Act item) {
        this.charges.remove(item.getObjectReference());
    }

    public boolean contains(Act item) {
        return this.contains(item.getObjectReference());
    }

    public boolean contains(Reference reference) {
        return this.charges.containsKey(reference);
    }

    public Set<Reference> getInvoiceRefs() {
        HashSet<Reference> invoices = new HashSet<Reference>();
        for (Act item : this.charges.values()) {
            IMObjectBean bean = this.service.getBean((IMObject)item);
            Reference invoiceRef = bean.getSourceRef("invoice");
            if (invoiceRef == null) continue;
            invoices.add(invoiceRef);
        }
        return invoices;
    }

    public List<Reference> getItemRefs(FinancialAct invoice) {
        return this.service.getBean((IMObject)invoice).getTargetRefs("items");
    }

    public boolean canClaimInvoice(FinancialAct invoice) {
        boolean result = false;
        if ("POSTED".equals(invoice.getStatus()) && !this.isReversed(invoice)) {
            result = this.claimContext.isGapClaim() || this.isPaid(invoice);
        }
        return result;
    }

    public boolean isPaid(FinancialAct invoice) {
        return this.rules.isAllocated(invoice);
    }

    public boolean isUnpaid(FinancialAct invoice) {
        return MathRules.isZero((BigDecimal)invoice.getAllocatedAmount());
    }

    public boolean isReversed(FinancialAct invoice) {
        return this.rules.isReversed(invoice);
    }

    public boolean canClaimItem(Act item) {
        FinancialAct invoice;
        boolean result = false;
        if (!this.contains(item) && (invoice = this.getInvoice(item)) != null && this.canClaimInvoice(invoice)) {
            result = this.canClaim(item);
        }
        return result;
    }

    public List<FinancialAct> getInvoices() {
        ArrayList<FinancialAct> invoices = new ArrayList<FinancialAct>();
        for (Reference ref : this.getInvoiceRefs()) {
            FinancialAct invoice = (FinancialAct)this.service.get(ref, FinancialAct.class);
            if (invoice == null) continue;
            invoices.add(invoice);
        }
        return invoices;
    }

    public FinancialAct getItem(Reference item, Reference patient) {
        IMObjectBean itemBean;
        FinancialAct result = null;
        FinancialAct act = (FinancialAct)this.cache.get(item);
        if (act != null && Objects.equals(patient, (itemBean = this.service.getBean((IMObject)act)).getTargetRef("patient"))) {
            result = act;
        }
        return result;
    }

    public boolean canClaim(Act item) {
        return this.getClaim(item, null) == null;
    }

    public Act getClaim(Act item, Act exclude) {
        return this.claimHelper.getClaim(item, exclude);
    }

    public FinancialAct getInvoice(Act item) {
        return (FinancialAct)this.service.getBean((IMObject)item).getSource("invoice", FinancialAct.class);
    }

    public Matches getMatches(FinancialAct invoice, Party patient) {
        Matches result;
        ArrayList<FinancialAct> matches = new ArrayList<FinancialAct>();
        boolean claimed = false;
        boolean reversed = this.isReversed(invoice);
        boolean paid = false;
        boolean mustBePaid = this.getChargesMustBePaid();
        if (!reversed) {
            Reference patientRef = patient.getObjectReference();
            paid = this.isPaid(invoice);
            if (!mustBePaid || paid) {
                for (Reference itemRef : this.getItemRefs(invoice)) {
                    if (!this.contains(itemRef)) {
                        FinancialAct item = this.getItem(itemRef, patientRef);
                        if (item == null) continue;
                        if (this.canClaim((Act)item)) {
                            matches.add(item);
                            continue;
                        }
                        claimed = true;
                        continue;
                    }
                    claimed = true;
                }
            }
        }
        if (!matches.isEmpty()) {
            result = new Matches(matches);
        } else {
            String displayName = DescriptorHelper.getDisplayName((String)"act.customerAccountChargesInvoice", (ArchetypeService)this.service);
            String message = reversed ? Messages.format((String)"patient.insurance.charge.reversed", (Object[])new Object[]{displayName}) : (claimed ? Messages.format((String)"patient.insurance.charge.allclaimed", (Object[])new Object[]{displayName}) : (!paid && mustBePaid ? (this.isGapClaimAvailable() ? Messages.format((String)"patient.insurance.charge.unpaid.gapavailable", (Object[])new Object[]{displayName}) : (this.isUnpaid(invoice) ? Messages.format((String)"patient.insurance.charge.unpaid", (Object[])new Object[]{displayName}) : Messages.format((String)"patient.insurance.charge.partpaid", (Object[])new Object[]{displayName}))) : Messages.format((String)"patient.insurance.charge.nocharges", (Object[])new Object[]{displayName, patient.getName()})));
            result = new Matches(message);
        }
        return result;
    }

    public boolean isFullyClaimed(FinancialAct invoice) {
        Reference patient = this.claimContext.getPatient().getObjectReference();
        for (Reference item : this.getItemRefs(invoice)) {
            if (this.getItem(item, patient) == null || this.charges.containsKey(item)) continue;
            return false;
        }
        return true;
    }

    public static class Matches {
        private final List<FinancialAct> items;
        private final String message;

        public Matches(String message) {
            this.items = Collections.emptyList();
            this.message = message;
        }

        public Matches(List<FinancialAct> items) {
            this.items = items;
            this.message = null;
        }

        public List<FinancialAct> getItems() {
            return this.items;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }
    }
}

